/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.util.IterationType;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class SortedQueryResultSet
extends AbstractSet<Map.Entry> {
    private final List<Map.Entry> entries;
    private final IterationType iterationType;

    public SortedQueryResultSet() {
        this(null, null);
    }

    public SortedQueryResultSet(List<Map.Entry> entries, IterationType iterationType) {
        this.entries = entries;
        this.iterationType = iterationType;
    }

    @Override
    public Iterator iterator() {
        if (this.entries == null) {
            return new EmptyIterator();
        }
        return new SortedIterator();
    }

    @Override
    public int size() {
        if (this.entries == null) {
            return 0;
        }
        return this.entries.size();
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SortedIterator
    implements Iterator {
        final Iterator<Map.Entry> iter;

        private SortedIterator() {
            this.iter = SortedQueryResultSet.this.entries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            Map.Entry entry = this.iter.next();
            if (SortedQueryResultSet.this.iterationType == IterationType.VALUE) {
                return entry.getValue();
            }
            if (SortedQueryResultSet.this.iterationType == IterationType.KEY) {
                return entry.getKey();
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

