/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.AlternateFormatsCountryCodeSet;
import com.google.i18n.phonenumbers.PhoneNumberMatcher;
import com.google.i18n.phonenumbers.ShortNumbersRegionCodeSet;
import com.google.i18n.phonenumbers.nano.Phonemetadata;
import com.google.protobuf.nano.CodedInputByteBufferNano;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataManager {
    private static final String ALTERNATE_FORMATS_FILE_PREFIX = "/com/google/i18n/phonenumbers/data/PhoneNumberAlternateFormatsProto";
    private static final String SHORT_NUMBER_METADATA_FILE_PREFIX = "/com/google/i18n/phonenumbers/data/ShortNumberMetadataProto";
    private static final Logger LOGGER = Logger.getLogger(MetadataManager.class.getName());
    private static final Map<Integer, Phonemetadata.PhoneMetadata> callingCodeToAlternateFormatsMap = Collections.synchronizedMap(new HashMap());
    private static final Map<String, Phonemetadata.PhoneMetadata> regionCodeToShortNumberMetadataMap = Collections.synchronizedMap(new HashMap());
    private static final Set<Integer> countryCodeSet = AlternateFormatsCountryCodeSet.getCountryCodeSet();
    private static final Set<String> regionCodeSet = ShortNumbersRegionCodeSet.getRegionCodeSet();
    private static final int BUFFER_SIZE = 16384;

    private MetadataManager() {
    }

    private static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.toString());
            }
        }
    }

    static CodedInputByteBufferNano convertStreamToByteBuffer(ObjectInputStream in, int bufferSize) throws IOException {
        int nRead;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] data = new byte[bufferSize];
        while ((nRead = in.read(data, 0, bufferSize)) != -1) {
            outputStream.write(data, 0, nRead);
        }
        outputStream.flush();
        return CodedInputByteBufferNano.newInstance(outputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadAlternateFormatsMetadataFromFile(int countryCallingCode) {
        String string = String.valueOf(String.valueOf("/com/google/i18n/phonenumbers/data/PhoneNumberAlternateFormatsProto_"));
        int n = countryCallingCode;
        InputStream source = PhoneNumberMatcher.class.getResourceAsStream(new StringBuilder(11 + string.length()).append(string).append(n).toString());
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(source);
            CodedInputByteBufferNano byteBuffer = MetadataManager.convertStreamToByteBuffer(in, 16384);
            Phonemetadata.PhoneMetadataCollection alternateFormats = new Phonemetadata.PhoneMetadataCollection();
            alternateFormats.mergeFrom(byteBuffer);
            for (Phonemetadata.PhoneMetadata metadata : alternateFormats.metadata) {
                callingCodeToAlternateFormatsMap.put(metadata.countryCode, metadata);
            }
        }
        catch (IOException e) {
            try {
                LOGGER.log(Level.WARNING, e.toString());
            }
            catch (Throwable throwable) {
                MetadataManager.close(in);
                throw throwable;
            }
            MetadataManager.close(in);
        }
        MetadataManager.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Phonemetadata.PhoneMetadata getAlternateFormatsForCountry(int countryCallingCode) {
        if (!countryCodeSet.contains(countryCallingCode)) {
            return null;
        }
        Map<Integer, Phonemetadata.PhoneMetadata> map = callingCodeToAlternateFormatsMap;
        synchronized (map) {
            if (!callingCodeToAlternateFormatsMap.containsKey(countryCallingCode)) {
                MetadataManager.loadAlternateFormatsMetadataFromFile(countryCallingCode);
            }
        }
        return callingCodeToAlternateFormatsMap.get(countryCallingCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadShortNumberMetadataFromFile(String regionCode) {
        String string = String.valueOf("/com/google/i18n/phonenumbers/data/ShortNumberMetadataProto_");
        String string2 = String.valueOf(regionCode);
        InputStream source = PhoneNumberMatcher.class.getResourceAsStream(string2.length() != 0 ? string.concat(string2) : new String(string));
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(source);
            CodedInputByteBufferNano byteBuffer = MetadataManager.convertStreamToByteBuffer(in, 16384);
            Phonemetadata.PhoneMetadataCollection shortNumberMetadata = new Phonemetadata.PhoneMetadataCollection();
            shortNumberMetadata.mergeFrom(byteBuffer);
            for (Phonemetadata.PhoneMetadata metadata : shortNumberMetadata.metadata) {
                regionCodeToShortNumberMetadataMap.put(regionCode, metadata);
            }
        }
        catch (IOException e) {
            try {
                LOGGER.log(Level.WARNING, e.toString());
            }
            catch (Throwable throwable) {
                MetadataManager.close(in);
                throw throwable;
            }
            MetadataManager.close(in);
        }
        MetadataManager.close(in);
    }

    static Set<String> getShortNumberMetadataSupportedRegions() {
        return regionCodeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Phonemetadata.PhoneMetadata getShortNumberMetadataForRegion(String regionCode) {
        if (!regionCodeSet.contains(regionCode)) {
            return null;
        }
        Map<String, Phonemetadata.PhoneMetadata> map = regionCodeToShortNumberMetadataMap;
        synchronized (map) {
            if (!regionCodeToShortNumberMetadataMap.containsKey(regionCode)) {
                MetadataManager.loadShortNumberMetadataFromFile(regionCode);
            }
        }
        return regionCodeToShortNumberMetadataMap.get(regionCode);
    }
}

