/*
 * Decompiled with CFR 0.152.
 */
package com.planetj.math.rabinhash;

import com.planetj.math.rabinhash.RabinHashFunction64;
import java.security.DigestException;
import java.security.MessageDigestSpi;

public final class RHF64
extends MessageDigestSpi
implements Cloneable {
    private final RabinHashFunction64 rhf = RabinHashFunction64.DEFAULT_HASH_FUNCTION;
    private long hash;

    protected int engineGetDigestLength() {
        return 8;
    }

    protected void engineUpdate(byte input) {
        this.hash = this.rhf.hash(new byte[]{input}, 0, 1, this.hash);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.hash = this.rhf.hash(input, offset, len, this.hash);
    }

    protected byte[] engineDigest() {
        byte[] buf = new byte[8];
        this.hashToBuf(buf, 0);
        this.engineReset();
        return buf;
    }

    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < 8) {
            throw new DigestException("Output buffer is smaller than digest length of 8");
        }
        this.hashToBuf(buf, offset);
        this.engineReset();
        return 8;
    }

    protected void engineReset() {
        this.hash = 0L;
    }

    private void hashToBuf(byte[] buf, int offset) {
        buf[offset] = (byte)(this.hash >> 56);
        buf[offset + 1] = (byte)(this.hash >> 48);
        buf[offset + 2] = (byte)(this.hash >> 40);
        buf[offset + 3] = (byte)(this.hash >> 32);
        buf[offset + 4] = (byte)(this.hash >> 24);
        buf[offset + 5] = (byte)(this.hash >> 16);
        buf[offset + 6] = (byte)(this.hash >> 8);
        buf[offset + 7] = (byte)this.hash;
    }
}

