/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.stringsearch;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class CharIntMap
implements Externalizable {
    static final long serialVersionUID = 1351686633123489568L;
    private int[] array;
    private char lowest;
    private int defaultValue;

    public CharIntMap() {
    }

    public CharIntMap(int extent, char lowest, int defaultValue) {
        this.array = new int[extent];
        this.lowest = lowest;
        this.defaultValue = defaultValue;
        if (defaultValue != 0) {
            int i = 0;
            while (i < this.array.length) {
                this.array[i] = defaultValue;
                ++i;
            }
        }
    }

    public final int get(char c) {
        char x = (char)(c - this.lowest);
        if (x >= this.array.length) {
            return this.defaultValue;
        }
        return this.array[x];
    }

    public final void set(char c, int val) {
        char x = (char)(c - this.lowest);
        if (x >= this.array.length) {
            return;
        }
        this.array[x] = val;
    }

    public final int getExtent() {
        return this.array.length;
    }

    public final char getLowest() {
        return this.lowest;
    }

    public final char getHighest() {
        return (char)(this.lowest + this.array.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharIntMap)) {
            return false;
        }
        CharIntMap m = (CharIntMap)obj;
        if (this.lowest != m.lowest) {
            return false;
        }
        if (this.defaultValue != m.defaultValue) {
            return false;
        }
        if (this.array == null && m.array == null) {
            return true;
        }
        return Arrays.equals(this.array, m.array);
    }

    public int hashCode() {
        int out = this.getClass().getName().hashCode();
        out ^= this.lowest;
        out ^= this.defaultValue;
        if (this.array != null) {
            int i = 0;
            while (i < this.array.length) {
                out ^= this.array[i];
                ++i;
            }
        }
        return out;
    }

    public final String toString() {
        return this.toStringBuffer(null).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer in) {
        StringBuffer out = in;
        if (out == null) {
            out = new StringBuffer(128);
        } else {
            out.ensureCapacity(out.length() + 128);
        }
        out.append("{ CharIntMap: lowest = ");
        out.append(this.lowest);
        out.append(", defaultValue = ");
        out.append(this.defaultValue);
        if (this.array != null) {
            out.append(", array = ");
            int i = 0;
            while (i < this.array.length) {
                if (this.array[i] != 0) {
                    out.append(i);
                    out.append(": ");
                    out.append(this.array[i]);
                    out.append(' ');
                }
                ++i;
            }
        }
        out.append('}');
        return out;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.array == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.array.length);
            int i = 0;
            while (i < this.array.length) {
                out.writeInt(this.array[i]);
                ++i;
            }
        }
        out.writeChar(this.lowest);
        out.writeInt(this.defaultValue);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int l = in.readInt();
        if (l > 0) {
            this.array = new int[l];
            int i = 0;
            while (i < this.array.length) {
                this.array[i] = in.readInt();
                ++i;
            }
        }
        this.lowest = in.readChar();
        this.defaultValue = in.readInt();
    }
}

