/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples;

import org.javasimon.SimonManager;
import org.javasimon.SimonState;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.utils.BenchmarkUtils;
import org.javasimon.utils.GoogleChartImageGenerator;

public final class DisabledEnabledComparison {
    private static final int LOOP = 10000000;

    private DisabledEnabledComparison() {
    }

    public static void main(String[] args) {
        StopwatchSample[] results = BenchmarkUtils.run((int)2, (int)5, (BenchmarkUtils.Task[])new BenchmarkUtils.Task[]{new BenchmarkUtils.Task("enabled"){

            public void perform() throws Exception {
                SimonManager.clear();
                SimonManager.enable();
                Stopwatch tested = SimonManager.getStopwatch((String)"org.javasimon.stopwatch");
                for (int i = 0; i < 10000000; ++i) {
                    tested.start().stop();
                }
            }
        }, new BenchmarkUtils.Task("disabled"){

            public void perform() throws Exception {
                SimonManager.clear();
                SimonManager.enable();
                Stopwatch tested = SimonManager.getStopwatch((String)"org.javasimon.stopwatch");
                tested.setState(SimonState.DISABLED, false);
                for (int i = 0; i < 10000000; ++i) {
                    tested.start().stop();
                }
            }
        }, new BenchmarkUtils.Task("mgr-enabled"){

            public void perform() throws Exception {
                SimonManager.clear();
                SimonManager.enable();
                for (int i = 0; i < 10000000; ++i) {
                    SimonManager.getStopwatch((String)"org.javasimon.stopwatch").start().stop();
                }
            }
        }, new BenchmarkUtils.Task("mgr-disabled"){

            public void perform() throws Exception {
                SimonManager.clear();
                SimonManager.disable();
                for (int i = 0; i < 10000000; ++i) {
                    SimonManager.getStopwatch((String)"org.javasimon.stopwatch").start().stop();
                }
            }
        }, new BenchmarkUtils.Task("assign-ns"){

            public void perform() throws Exception {
                for (int i = 0; i < 10000000; ++i) {
                    long l = System.nanoTime();
                }
            }
        }});
        System.out.println("\nGoogle Chart avg:\n" + GoogleChartImageGenerator.barChart((StopwatchSample[])results, (String)"10M-loop duration", (double)1000000.0, (String)"ms", (boolean)false));
    }
}

