/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xslf.usermodel.Placeholder;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFComments;
import org.apache.poi.xslf.usermodel.XSLFGraphicFrame;
import org.apache.poi.xslf.usermodel.XSLFGroupShape;
import org.apache.poi.xslf.usermodel.XSLFNotes;
import org.apache.poi.xslf.usermodel.XSLFPictureShape;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.poi.xslf.usermodel.XSLFTableCell;
import org.apache.poi.xslf.usermodel.XSLFTableRow;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.presentationml.x2006.main.CTComment;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPicture;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdListEntry;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XSLFPowerPointExtractorDecorator
extends AbstractOOXMLExtractor {
    public XSLFPowerPointExtractorDecorator(ParseContext context, XSLFPowerPointExtractor extractor) {
        super(context, extractor);
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, IOException {
        XSLFSlide[] slides;
        XMLSlideShow slideShow = (XMLSlideShow)this.extractor.getDocument();
        for (XSLFSlide slide : slides = slideShow.getSlides()) {
            XSLFComments comments;
            String slideDesc;
            if (slide.getPackagePart() != null && slide.getPackagePart().getPartName() != null) {
                slideDesc = this.getJustFileName(slide.getPackagePart().getPartName().toString());
                slideDesc = slideDesc + "_";
            } else {
                slideDesc = null;
            }
            this.extractContent(slide.getShapes(), false, xhtml, slideDesc);
            XSLFSlideLayout slideLayout = slide.getMasterSheet();
            this.extractContent(slideLayout.getShapes(), true, xhtml, null);
            XSLFSheet slideMaster = ((XSLFSheet)slideLayout).getMasterSheet();
            this.extractContent(slideMaster.getShapes(), true, xhtml, null);
            XSLFNotes slideNotes = slide.getNotes();
            if (slideNotes != null) {
                this.extractContent(slideNotes.getShapes(), false, xhtml, slideDesc);
                XSLFSheet notesMaster = ((XSLFSheet)slideNotes).getMasterSheet();
                this.extractContent(notesMaster.getShapes(), true, xhtml, null);
            }
            if ((comments = slide.getComments()) == null) continue;
            for (CTComment comment : comments.getCTCommentsList().getCmList()) {
                xhtml.element("p", comment.getText());
            }
        }
    }

    private void extractContent(XSLFShape[] shapes, boolean skipPlaceholders, XHTMLContentHandler xhtml, String slideDesc) throws SAXException {
        for (XSLFShape sh : shapes) {
            String relID;
            CTPicture ctPic;
            if (sh instanceof XSLFTextShape) {
                XSLFTextShape txt = (XSLFTextShape)sh;
                Placeholder ph = txt.getTextType();
                if (skipPlaceholders && ph != null) continue;
                xhtml.element("p", txt.getText());
                continue;
            }
            if (sh instanceof XSLFGroupShape) {
                XSLFGroupShape group = (XSLFGroupShape)sh;
                this.extractContent(group.getShapes(), skipPlaceholders, xhtml, slideDesc);
                continue;
            }
            if (sh instanceof XSLFTable) {
                XSLFTable tbl = (XSLFTable)sh;
                for (XSLFTableRow row : tbl) {
                    List<XSLFTableCell> cells = row.getCells();
                    this.extractContent(cells.toArray(new XSLFTableCell[cells.size()]), skipPlaceholders, xhtml, slideDesc);
                }
                continue;
            }
            if (sh instanceof XSLFGraphicFrame) {
                XSLFGraphicFrame frame = (XSLFGraphicFrame)sh;
                XmlObject[] sp = frame.getXmlObject().selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:oleObj");
                if (sp == null) continue;
                for (XmlObject emb : sp) {
                    XmlObject relIDAtt = emb.selectAttribute(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id"));
                    if (relIDAtt == null) continue;
                    String relID2 = relIDAtt.getDomNode().getNodeValue();
                    if (slideDesc != null) {
                        relID2 = slideDesc + relID2;
                    }
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute("", "class", "class", "CDATA", "embedded");
                    attributes.addAttribute("", "id", "id", "CDATA", relID2);
                    xhtml.startElement("div", attributes);
                    xhtml.endElement("div");
                }
                continue;
            }
            if (!(sh instanceof XSLFPictureShape) || skipPlaceholders || !(sh.getXmlObject() instanceof CTPicture) || (ctPic = (CTPicture)sh.getXmlObject()).getBlipFill() == null || ctPic.getBlipFill().getBlip() == null || (relID = ctPic.getBlipFill().getBlip().getEmbed()) == null) continue;
            if (slideDesc != null) {
                relID = slideDesc + relID;
            }
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "class", "class", "CDATA", "embedded");
            attributes.addAttribute("", "id", "id", "CDATA", relID);
            xhtml.startElement("div", attributes);
            xhtml.endElement("div");
        }
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() throws TikaException {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        XMLSlideShow slideShow = (XMLSlideShow)this.extractor.getDocument();
        XSLFSlideShow document = null;
        try {
            document = slideShow._getXSLFSlideShow();
        }
        catch (Exception e) {
            throw new TikaException(e.getMessage());
        }
        for (CTSlideIdListEntry ctSlide : document.getSlideReferences().getSldIdList()) {
            PackagePart slidePart;
            try {
                slidePart = document.getSlidePart(ctSlide);
            }
            catch (IOException e) {
                throw new TikaException("Broken OOXML file", e);
            }
            catch (XmlException xe) {
                throw new TikaException("Broken OOXML file", xe);
            }
            parts.add(slidePart);
            try {
                for (PackageRelationship rel : slidePart.getRelationshipsByType(XSLFRelation.VML_DRAWING.getRelation())) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    PackagePartName relName = PackagingURIHelper.createPartName(rel.getTargetURI());
                    parts.add(rel.getPackage().getPart(relName));
                }
            }
            catch (InvalidFormatException e) {
                throw new TikaException("Broken OOXML file", e);
            }
        }
        return parts;
    }
}

