package org.apache.jcs.engine;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import org.apache.jcs.engine.behavior.ICache;

/**
 * Used to associates a set of [cache listener to cache event queue] for a
 * cache.
 */
public class CacheListeners
{
    /** The cache using the queue. */
    public final ICache cache;

    /** Map ICacheListener to ICacheEventQueue */
    public final Map eventQMap = new Hashtable();

    /**
     * Constructs with the given cache.
     * <p>
     * @param cache
     */
    public CacheListeners( ICache cache )
    {
        if ( cache == null )
        {
            throw new IllegalArgumentException( "cache must not be null" );
        }
        this.cache = cache;
    }
    
    /** @return info on the listeners */
    public String toString()
    {
        StringBuffer buffer = new StringBuffer();
        buffer.append( "\n CacheListeners" );
        if ( cache != null )
        {
            buffer.append( "\n Region = " + cache.getCacheName() );
        }
        if ( eventQMap != null )
        {
            buffer.append( "\n Event Queue Map " );
            buffer.append( "\n size = " + eventQMap.size() );
            Iterator it = eventQMap.entrySet().iterator();
            while ( it.hasNext() )
            {
                buffer.append( "\n Entry: " + it.next() );               
            }                
        }
        else
        {
            buffer.append( "\n No Listeners. " );
        }
        return buffer.toString();
    }
}
