/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.freebusy;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.exception.OXExceptionStrings;

/**
 * {@link FreeBusyExceptionCodes}
 *
 * Exception codes for the free/busy subsystem.
 *
 * @author <a href="mailto:tobias.friedrich@open-xchange.com">Tobias Friedrich</a>
 */
public enum FreeBusyExceptionCodes implements DisplayableOXExceptionCode {

    NO_PROVIDERS_AVAILABLE("No free/busy providers available.", FreeBusyExceptionMessages.NO_PROVIDERS_AVAILABLE_MSG, Category.CATEGORY_SERVICE_DOWN, 1),
    AMBIGUOUS_PARTICIPANT("The participant \"%1$s\" is ambiguous.", FreeBusyExceptionMessages.AMBIGUOUS_PARTICIPANT_MSG, Category.CATEGORY_CONFLICT, 2),
    PARTICIPANT_NOT_FOUND("The participant \"%1$s\" can't be found.", FreeBusyExceptionMessages.PARTICIPANT_NOT_FOUND_MSG, CATEGORY_USER_INPUT, 3),
    FREEBUSY_NOT_ENABLED("Free/busy is not enabled for user %1$d in context %2$d.", FreeBusyExceptionMessages.FREEBUSY_NOT_ENABLED_MSG, CATEGORY_PERMISSION_DENIED, 4),
    DATA_NOT_AVAILABLE("Free/busy data for \"%1$s\" is not available.", FreeBusyExceptionMessages.DATA_NOT_AVAILABLE_MSG, CATEGORY_USER_INPUT, 5),
    COMMUNICATION_FAILURE("A communication error occured while processing the free/busy request (\"%1$s\").", OXExceptionStrings.MESSAGE, CATEGORY_SERVICE_DOWN, 6),
    EXTERNAL_ERROR("An external error occured while processing the free/busy request (\"%1$s\").", OXExceptionStrings.MESSAGE, CATEGORY_ERROR, 7),
    INTERNAL_ERROR("An internal error occured while processing the free/busy request (\"%1$s\").", OXExceptionStrings.MESSAGE, CATEGORY_ERROR, 8),
    CONFIGURATION_ERROR("A configuration error occured (\"%1$s\").", OXExceptionStrings.MESSAGE, CATEGORY_CONFIGURATION, 9),
    ;

    private static final String PREFIX = "FRB";

    private final Category category;
    private final int number;
    private final String message;
    private final String displayMessage;

    private FreeBusyExceptionCodes(String message, final String displayMessage, Category category, int detailNumber) {
        this.message = message;
        number = detailNumber;
        this.category = category;
        this.displayMessage = displayMessage;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Category getCategory() {
        return category;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public int getNumber() {
        return number;
    }

    @Override
    public boolean equals(final OXException e) {
        return OXExceptionFactory.getInstance().equals(this, e);
    }

    /**
     * Creates a new {@link OXException} instance pre-filled with this code's attributes.
     *
     * @return The newly created {@link OXException} instance
     */
    public OXException create() {
        return OXExceptionFactory.getInstance().create(this, new Object[0]);
    }

    /**
     * Creates a new {@link OXException} instance pre-filled with this code's attributes.
     *
     * @param args The message arguments in case of printf-style message
     * @return The newly created {@link OXException} instance
     */
    public OXException create(final Object... args) {
        return OXExceptionFactory.getInstance().create(this, (Throwable) null, args);
    }

    /**
     * Creates a new {@link OXException} instance pre-filled with this code's attributes.
     *
     * @param cause The optional initial cause
     * @param args The message arguments in case of printf-style message
     * @return The newly created {@link OXException} instance
     */
    public OXException create(final Throwable cause, final Object... args) {
        return OXExceptionFactory.getInstance().create(this, cause, args);
    }

    /* (non-Javadoc)
     * @see com.openexchange.exception.DisplayableOXExceptionCode#getDisplayMessage()
     */
    @Override
    public String getDisplayMessage() {
        return displayMessage;
    }

}
