/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.fetcher.impl;

import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.SyndFeedInfo;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HashMapFeedInfoCache
implements FeedFetcherCache,
Serializable {
    private static final long serialVersionUID = -1594665619950916222L;
    static HashMapFeedInfoCache _instance;
    private Map infoCache;

    public HashMapFeedInfoCache() {
        this.setInfoCache(this.createInfoCache());
    }

    public static synchronized FeedFetcherCache getInstance() {
        if (_instance == null) {
            _instance = new HashMapFeedInfoCache();
        }
        return _instance;
    }

    protected Map createInfoCache() {
        return Collections.synchronizedMap(new HashMap());
    }

    protected Object get(Object key) {
        return this.getInfoCache().get(key);
    }

    public SyndFeedInfo getFeedInfo(URL feedUrl) {
        return (SyndFeedInfo)this.get(feedUrl.toString());
    }

    protected void put(Object key, Object value) {
        this.getInfoCache().put(key, value);
    }

    public void setFeedInfo(URL feedUrl, SyndFeedInfo syndFeedInfo) {
        this.put(feedUrl.toString(), syndFeedInfo);
    }

    protected final synchronized Map getInfoCache() {
        return this.infoCache;
    }

    protected final synchronized void setInfoCache(Map map) {
        this.infoCache = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.infoCache;
        synchronized (map) {
            this.infoCache.clear();
        }
    }

    public SyndFeedInfo remove(URL url) {
        if (url == null) {
            return null;
        }
        return (SyndFeedInfo)this.infoCache.remove(url.toString());
    }
}

