/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;

public class DefaultCssErrorHandler
implements ErrorHandler,
Serializable {
    private static final long serialVersionUID = 4655126263007765782L;
    private final Log log_ = LogFactory.getLog(DefaultCssErrorHandler.class);

    public void error(CSSParseException exception) {
        this.log_.warn((Object)("CSS error: " + this.buildMessage(exception)));
    }

    public void fatalError(CSSParseException exception) {
        this.log_.warn((Object)("CSS fatal error: " + this.buildMessage(exception)));
    }

    public void warning(CSSParseException exception) {
        this.log_.warn((Object)("CSS warning: " + this.buildMessage(exception)));
    }

    private String buildMessage(CSSParseException exception) {
        String uri = exception.getURI();
        int line = exception.getLineNumber();
        int col = exception.getColumnNumber();
        String msg = exception.getMessage();
        return uri + " [" + line + ":" + col + "] " + msg;
    }
}

