/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.Architecture;
import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.Code;
import com.openexchange.obs.api.PackageStatus;
import com.openexchange.obs.api.ProjectReference;
import com.openexchange.obs.api.RepositoryReference;
import com.openexchange.obs.api.Result;
import com.openexchange.obs.api.State;
import com.openexchange.obs.api.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ResultParser {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    private ResultParser() {
    }

    public static Result[] parse(InputStream is) throws BuildServiceException {
        Document document;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(is);
            NodeList childs = document.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if ("resultlist".equals(node.getNodeName())) {
                    return ResultParser.parseResultList(node);
                }
                if (3 == node.getNodeType()) continue;
                throw new BuildServiceException("Unknown node in build result \"" + node.getNodeName() + "\".");
            }
        }
        catch (ParserConfigurationException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        throw new BuildServiceException("Unable to parse build result. " + Tools.transform(document));
    }

    private static Result[] parseResultList(Node resultList) throws BuildServiceException {
        NodeList childs = resultList.getChildNodes();
        ArrayList<Result> results = new ArrayList<Result>();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if ("result".equals(node.getNodeName())) {
                results.add(ResultParser.parseResult(node));
                continue;
            }
            if (3 == node.getNodeType()) continue;
            throw new BuildServiceException("Unknown node in result list \"" + node.getNodeName() + "\" \"" + node.getNodeValue() + "\".");
        }
        return results.toArray(new Result[results.size()]);
    }

    private static Result parseResult(Node resultNode) throws BuildServiceException {
        NamedNodeMap attributes = resultNode.getAttributes();
        ProjectReference project = new ProjectReference(attributes.getNamedItem("project").getNodeValue());
        RepositoryReference repository = new RepositoryReference(attributes.getNamedItem("repository").getNodeValue());
        String arch = attributes.getNamedItem("arch").getNodeValue();
        String state = attributes.getNamedItem("state").getNodeValue();
        boolean dirty = false;
        Node dirtyAttribute = attributes.getNamedItem("dirty");
        if (null != dirtyAttribute) {
            dirty = "true".equals(dirtyAttribute.getNodeValue());
        }
        Result result = new Result(project, repository, Architecture.parse(arch), State.parseState(state), dirty);
        NodeList childs = resultNode.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if ("status".equals(node.getNodeName())) {
                result.add(ResultParser.parseStatus(node));
                continue;
            }
            if (3 == node.getNodeType()) continue;
            throw new BuildServiceException("Unknown node in result \"" + node.getNodeName() + "\" \"" + node.getNodeValue() + "\".");
        }
        return result;
    }

    private static PackageStatus parseStatus(Node status) throws BuildServiceException {
        NamedNodeMap attributes = status.getAttributes();
        String name = attributes.getNamedItem("package").getNodeValue();
        String code = attributes.getNamedItem("code").getNodeValue();
        PackageStatus retval = new PackageStatus(name, Code.parseCode(code));
        NodeList childs = status.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if ("details".equals(node.getNodeName())) {
                retval.setDetails(ResultParser.parseDetails(node));
                continue;
            }
            if (3 == node.getNodeType()) continue;
            throw new BuildServiceException("Unknown node in result \"" + node.getNodeName() + "\" \"" + node.getNodeValue() + "\".");
        }
        return retval;
    }

    private static String parseDetails(Node details) {
        return details.getTextContent();
    }
}

