/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.jgit;

import com.openexchange.build.utils.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;

public class OXReleaseDescribeCommand
extends GitCommand<String> {
    private static final String TAG_PREFIX = Pattern.quote("refs/tags/");
    private static final String RELEASE_SUFFIX = "\\d+\\.\\d+\\.\\d+-\\d+";
    private static final Comparator<Candidate> SHORTEST = new Comparator<Candidate>(){

        @Override
        public int compare(Candidate o1, Candidate o2) {
            return o1.depth - o2.depth;
        }
    };
    private static final Comparator<Candidate> HIGHEST = new Comparator<Candidate>(){

        @Override
        public int compare(Candidate o1, Candidate o2) {
            try {
                System.err.println(o1.tag.getName() + " " + o2.tag.getName());
                return Version.parse((String)o1.tag.getName().substring("refs/tags/".length())).compareTo(Version.parse((String)o2.tag.getName().substring("refs/tags/".length())));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return 0;
            }
        }
    };
    private Pattern tagPattern;
    private Comparator<Candidate> mode = SHORTEST;
    private RevCommit target;
    private int maxCandidates = 10;
    private boolean longDesc;

    public OXReleaseDescribeCommand(Repository repo) {
        super(repo);
        this.tagPattern = Pattern.compile(TAG_PREFIX + RELEASE_SUFFIX);
    }

    public OXReleaseDescribeCommand settagPattern(String pattern) {
        this.tagPattern = Pattern.compile(TAG_PREFIX + pattern);
        return this;
    }

    public OXReleaseDescribeCommand setLong(boolean longDesc) {
        this.longDesc = longDesc;
        return this;
    }

    public void pickHighestVersion() {
        System.err.println("Highest mode");
        this.tagPattern = Pattern.compile(TAG_PREFIX + RELEASE_SUFFIX);
        this.mode = HIGHEST;
    }

    private String longDescription(Ref tag, int depth, ObjectId tip) throws IOException {
        return String.format("%s-%d-g%s", tag.getName().substring("refs/tags/".length()), depth, this.repo.newObjectReader().abbreviate((AnyObjectId)tip).name());
    }

    public String call() throws GitAPIException {
        RevWalk w = new RevWalk(this.repo);
        w.setRetainBody(false);
        try {
            RevCommit c;
            this.checkCallable();
            if (this.target == null) {
                this.target = w.parseCommit((AnyObjectId)this.repo.resolve("HEAD"));
            }
            HashMap<ObjectId, Ref> tags = new HashMap<ObjectId, Ref>();
            for (Ref r : this.repo.getRefDatabase().getRefs("refs/tags/").values()) {
                ObjectId key = this.repo.peel(r).getPeeledObjectId();
                if (key == null) {
                    key = r.getObjectId();
                }
                if (!this.tagPattern.matcher(r.getName()).matches()) continue;
                tags.put(key, r);
            }
            RevFlagSet allFlags = new RevFlagSet();
            ArrayList<Candidate> candidates = new ArrayList<Candidate>();
            Ref lucky = (Ref)tags.get(this.target);
            if (lucky != null) {
                String string = this.longDesc ? this.longDescription(lucky, 0, (ObjectId)this.target) : lucky.getName().substring("refs/tags/".length());
                return string;
            }
            w.markStart(this.target);
            int seen = 0;
            while ((c = w.next()) != null) {
                Ref t;
                if (!c.hasAny(allFlags) && (t = (Ref)tags.get(c)) != null) {
                    RevFlag flag = w.newFlag(t.getName());
                    Candidate cd = new Candidate(c, t, flag);
                    candidates.add(cd);
                    cd.depth = seen;
                    allFlags.add(flag);
                    w.carry(flag);
                }
                for (Candidate cd : candidates) {
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
                if (candidates.size() >= this.maxCandidates) break;
                ++seen;
            }
            while ((c = w.next()) != null) {
                if (c.hasAll(allFlags)) {
                    for (RevCommit p : c.getParents()) {
                        p.add(RevFlag.SEEN);
                    }
                    continue;
                }
                for (Candidate cd : candidates) {
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
            }
            if (candidates.isEmpty()) {
                Iterator i$ = null;
                return i$;
            }
            Candidate best = this.mode == HIGHEST ? Collections.max(candidates, this.mode) : Collections.min(candidates, this.mode);
            String string = best.describe((ObjectId)this.target);
            return string;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.setCallable(false);
            w.close();
        }
    }

    class Candidate {
        final Ref tag;
        final RevFlag flag;
        int depth;

        Candidate(RevCommit commit, Ref tag, RevFlag flag) {
            this.tag = tag;
            this.flag = flag;
            commit.add(flag);
            commit.carry(flag);
        }

        RevFlag getFlag() {
            return this.flag;
        }

        boolean reaches(RevCommit c) {
            return c.has(this.flag);
        }

        String describe(ObjectId tip) throws IOException {
            return OXReleaseDescribeCommand.this.longDescription(this.tag, this.depth, tip);
        }
    }
}

