/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;

public class ForEach
extends Instruction
implements ContextMappingFunction {
    private Expression select;
    private Expression action;

    public ForEach(Expression expression, Expression expression2) {
        this.select = expression;
        this.action = expression2;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
    }

    public int getInstructionNameCode() {
        return 145;
    }

    public Expression getActionExpression() {
        return this.action;
    }

    public final ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.action.getItemType(typeHierarchy);
    }

    public final boolean createsNewNodes() {
        int n = this.action.getSpecialProperties();
        return (n & 0x400000) == 0;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        this.action = this.action.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        this.select = this.select.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.select);
        this.action = this.action.typeCheck(staticContext, this.select.getItemType(typeHierarchy));
        this.adoptChildExpression(this.action);
        if (this.select instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        if (this.action instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        this.select = this.select.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.select);
        this.action = this.action.optimize(optimizer, staticContext, this.select.getItemType(typeHierarchy));
        this.adoptChildExpression(this.action);
        if (this.select instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        if (this.action instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        PromotionOffer promotionOffer = new PromotionOffer(optimizer);
        promotionOffer.action = 10;
        promotionOffer.promoteDocumentDependent = (this.select.getSpecialProperties() & 0x10000) != 0;
        promotionOffer.promoteXSLTFunctions = false;
        promotionOffer.containingExpression = this;
        this.action = this.doPromotion(this.action, promotionOffer);
        if (promotionOffer.containingExpression instanceof LetExpression) {
            promotionOffer.containingExpression = promotionOffer.containingExpression.optimize(optimizer, staticContext, itemType);
        }
        return promotionOffer.containingExpression;
    }

    public int computeDependencies() {
        int n = 0;
        n |= this.select.getDependencies();
        return n |= this.action.getDependencies() & 0xFFFFFFE1;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.doPromotion(this.select, promotionOffer);
        this.action = this.doPromotion(this.action, promotionOffer);
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.select, this.action);
    }

    public int getImplementationMethod() {
        return 6;
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        this.action.checkPermittedContents(schemaType, staticContext, false);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentIterator(sequenceIterator);
        xPathContextMajor.setCurrentTemplateRule(null);
        if (controller.isTracing()) {
            Item item;
            TraceListener traceListener = controller.getTraceListener();
            while ((item = sequenceIterator.next()) != null) {
                traceListener.startCurrentItem(item);
                this.action.process(xPathContextMajor);
                traceListener.endCurrentItem(item);
            }
        } else {
            Item item;
            while ((item = sequenceIterator.next()) != null) {
                this.action.process(xPathContextMajor);
            }
        }
        return null;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentTemplateRule(null);
        xPathContextMajor.setCurrentIterator(sequenceIterator);
        sequenceIterator = new ContextMappingIterator(this, xPathContextMajor);
        return sequenceIterator;
    }

    public SequenceIterator map(XPathContext xPathContext) throws XPathException {
        return this.action.iterate(xPathContext);
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "for-each");
        this.select.display(n + 1, printStream, configuration);
        printStream.println(ExpressionTool.indent(n) + "return");
        this.action.display(n + 1, printStream, configuration);
    }
}

