/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public final class LocalParam
extends GeneralVariable {
    private Expression conversion = null;

    public void setConversion(Expression expression) {
        this.conversion = expression;
    }

    public int getInstructionNameCode() {
        return 170;
    }

    public Iterator iterateSubExpressions() {
        if (this.select != null && this.conversion != null) {
            return new PairIterator(this.select, this.conversion);
        }
        if (this.select != null) {
            return new MonoIterator(this.select);
        }
        if (this.conversion != null) {
            return new MonoIterator(this.conversion);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        boolean bl = xPathContext.useLocalParameter(this.getVariableFingerprint(), this, this.isTunnelParam());
        if (bl) {
            if (this.conversion != null) {
                xPathContext.setLocalVariable(this.getSlotNumber(), ExpressionTool.eagerEvaluate(this.conversion, xPathContext));
            }
        } else {
            if (this.isImplicitlyRequiredParam()) {
                DynamicError dynamicError = new DynamicError("A value must be supplied for the parameter because the default value is not a valid instance of the required type");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setErrorCode("XTDE0610");
                throw dynamicError;
            }
            if (this.isRequiredParam()) {
                DynamicError dynamicError = new DynamicError("No value supplied for required parameter");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setErrorCode("XTDE0700");
                throw dynamicError;
            }
            xPathContext.setLocalVariable(this.getSlotNumber(), this.getSelectValue(xPathContext));
        }
        return null;
    }

    public ValueRepresentation evaluateVariable(XPathContext xPathContext) {
        return xPathContext.evaluateLocalVariable(this.getSlotNumber());
    }
}

