/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2011 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.packaging;

import java.util.regex.Matcher;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import com.openexchange.Definitions;

/**
 * Calculates the version number of the next minor release based on the given version number.
 *
 * @author <a href="mailto:steffen.templin@open-xchange.com">Steffen Templin</a>
 */
public final class NextMinor extends Task {

    private String current;
    private String property;

    public NextMinor() {
        super();
    }

    public void setCurrent(String current) {
        this.current = current;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    @Override
    public void execute() throws BuildException {
        if (null == current) {
            throw new BuildException("Please provide the current version using attribute \"current\".");
        }
        if (null == property) {
            throw new BuildException("Please define property carrying the next minor version using attribute \"property\".");
        }
        Matcher matcher = Definitions.VERSION_PATTERN.matcher(current);
        final String generation;
        final String major;
        int minor;
        if (matcher.matches()) {
            generation = matcher.group(1);
            major = matcher.group(2);
            try {
                minor = Integer.parseInt(matcher.group(3));
                // Calculate the next minor version number (which is a very difficult task ;-))
                minor++;
            } catch (NumberFormatException e) {
                // Can not happen if regex works properly
                throw new BuildException("Was not able to parse the minor part of the given version to a number.", e);
            }
        } else {
            throw new BuildException("Was not able to parse the given version number (" + current + ") which must be three decimal places separated with a dot e.g. 7.4.0");
        }
        String nextMinor = generation + '.' + major + '.' + Integer.toString(minor);
        getProject().log("Calculated the next minor release version number to " + nextMinor + ", which is stored into property " + property, Project.MSG_VERBOSE);
        getProject().setInheritedProperty(property, nextMinor);
    }
}
