/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dcd.graph;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import net.sourceforge.pmd.dcd.ClassLoaderUtil;
import net.sourceforge.pmd.dcd.asm.TypeSignatureVisitor;
import net.sourceforge.pmd.dcd.graph.ClassNode;
import net.sourceforge.pmd.dcd.graph.MemberNode;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodNode
extends MemberNode<MethodNode, Method> {
    private WeakReference<Method> methodReference;

    public MethodNode(ClassNode classNode, String name, String desc) {
        super(classNode, name, desc);
    }

    @Override
    public Method getMember() {
        Method method;
        Method method2 = method = this.methodReference == null ? null : (Method)this.methodReference.get();
        if (method == null) {
            SignatureReader signatureReader = new SignatureReader(this.desc);
            TypeSignatureVisitor visitor = new TypeSignatureVisitor();
            signatureReader.accept((SignatureVisitor)visitor);
            method = ClassLoaderUtil.getMethod(super.getClassNode().getType(), this.name, visitor.getMethodParameterTypes());
            this.methodReference = new WeakReference<Method>(method);
        }
        return method;
    }

    @Override
    public int compareTo(MethodNode that) {
        int cmp = this.getName().compareTo(that.getName());
        if (cmp == 0 && (cmp = this.getMember().getParameterTypes().length - that.getMember().getParameterTypes().length) == 0) {
            for (int i = 0; i < this.getMember().getParameterTypes().length && (cmp = this.getMember().getParameterTypes()[i].getName().compareTo(that.getMember().getParameterTypes()[i].getName())) == 0; ++i) {
            }
        }
        return cmp;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MethodNode) {
            MethodNode that = (MethodNode)obj;
            return super.equals(that);
        }
        return false;
    }
}

