/*global jQuery, ox, PATH, url, _, format, Join, config, internalCache */
/*jslint white: true, devel: true, browser: true, undef: true, forin: true, maxerr: 50, indent: 4 */

var $ = jQuery,
    node = $(),
    form,
    mail,
    password,
    fields,
    displayName = "",
    rDomain = /@(.+)$/,
    WIDTH = "450px";

// define service setter
ox.mail.services = null;

var closePopup = function () {
    node.popup("disable");
    node.remove();
    node = form = fields = mail = password = null;
};

var back = function (e) {
    var n = node;
    ox.mail.addAccount(e.data.addr);
    n.remove();
    n = null;
    return false;
};

var cancel = function () {
    closePopup();
    return false;
};

var def = function (val, alt) {
    return val !== undefined ? val : alt;
};

var getData = function (base, product) {

    var rShort = /@.+$/,
        addr = base.primary_address,
        pass = base.password;
        

    var data = $.extend({}, base, {
        // transport
        transport_protocol: def(product.transport_protocol, "smtp"),
        transport_server: product.transport_server,
        transport_secure: def(product.transport_secure, true),
        // mail
        mail_protocol: def(product.mail_protocol, "pop3"),
        mail_server: product.mail_server,
        mail_secure: def(product.mail_secure, true)
    });

    // ports
    data.transport_port = def(product.transport_port, data.transport_secure ? 465 : 25);
    data.mail_port = def(product.mail_port,
        data.mail_protocol === "pop3" ?
            (data.mail_secure ? 995 : 110) : /* pop3 */
            (data.mail_secure ? 993 : 143)   /* IMAP */
        );

    // mail auth
    if (product.mail_auth_short === true) {
        data.login = addr.replace(rShort, "");
    }

    // transport auth?
    if (product.transport_auth === true) {
        data.transport_credentials = true;
        data.transport_login = product.transport_auth_short === true ?
            addr.replace(rShort, "") : addr;
        data.transport_password = pass;
    }

    // pop3?
    if (data.mail_protocol === "pop3") {
        data.pop3_refresh_rate = 3;
        data.pop3_expunge_on_quit = false;
        data.pop3_delete_write_through = false;
        data.pop3_storage = "mailaccount";
    }

    return data;
};

var numProducts = function (service) {
    var products = service.products, id, count = 0;
    for (id in products) {
        count++;
    }
    return count;
};

var getProduct = function (service, id) {
    var i, products = service.products;
    for (i in products) {
        if (id === undefined || i === id) {
            return products[i];
        }
    }
};

var done = function (addr, service) {

    try {
        // get address
        var product,
            personal = fields.find("input[name=personal]").val(),
            pass = fields.find(":password").val(),
            data;

        // empty password?
        if (pass === "") {
            ox.UINotifier.warn(_("Enter your password"));
            return false;
        }

        // get product
        if (numProducts(service) === 1) {
            // get first product
            product = getProduct(service);
        } else {
            // get product by id
            product = getProduct(service, fields.find(":radio:checked").val());
        }

        // get data
        data = getData({
            personal: personal,
            name: service.name,
            primary_address: addr,
            unified_inbox_enabled: false,
            login: addr,
            password: pass,
            spam_handler: "NoSpamHandler",
            tree: false
        }, product);

        // debug
        if (url.dev === "plugin") {
            console.debug("Validate with", data);
        }

        // disable form
        form.css("visibility", "hidden")
            .find("input, button").attr("disabled", "disabled");
        form.parent().addClass("busy-spinner-white");

        // enable form
        var enable = function () {
            form.css("visibility", "")
                .find("input, button").removeAttr("disabled", "disabled");
            form.parent().removeClass("busy-spinner-white");
            password.focus();
        };

        // create account
        var create = function () {
            ox.api.account.create({
                data: data,
                success: function () {
                    // visual ok
                    ox.UINotifier.ok(_("Your mail account has been added"));
                    // update tree
                    ox.api.folder.dispatcher.trigger("modify");
                    // close popup
                    closePopup();
                },
                error: function () {
                    // duplicate names might fail, for example
                    enable();
                }
            });
        };

        // validate first
        ox.UINotifier.log(_("Trying to connect. This may take a moment..."));
        ox.api.account.validate(
            data,
            function (response) {
                // success?
                if (response.data === true) {
                    create();
                } else {
                    ox.UINotifier.error(_("Could not connect. Please check your settings!"));
                    enable();
                }
            },
            function () {
                enable();
            }
        );

    } catch (e) {
        if (url.dev) {
            console.error(e.description);
        }
    }

    return false;
};

var configureService = function (addr, service) {

    form.empty();

    // add logo?
    if (service.logo) {
        form.prepend(
            $("<div/>")
                .css({
                    height: service.logo.height || "auto",
                    margin: service.logo.margin || "0"
                })
                .append(
                    $("<img/>", {
                        src: PATH + "/services/logos/" + service.logo.src,
                        alt: ""
                    })
                )
        );
        node.find("h1").remove();
    } else {
        // add service name
        node.find("h1")
            .css({
                color: service.color || "#08c"
            })
            .text(String(service.name));
    }

    var next = function () {
        done(addr, service);
        return false;
    };

    // create second form
    form.unbind("submit")
        .bind("submit", next)
        .append(
            $("<div/>")
                .append(
                    $("<div/>") // mail address
                        .css({
                            fontFamily: "monospace",
                            fontSize: "11pt",
                            margin: service.logo ? "0 0 1em 0" : "1.5em 0 1em 0",
                            whiteSpace: "nowrap",
                            overflow: "hidden",
                            textOverflow: "ellipsis"
                        })
                        .text(addr)
                )
                .append(
                    fields = $("<div/>")
                        .append(
                            $("<div/>")
                                .css("marginTop", "1em")
                                .append(
                                    // display name / personal
                                    $("<label/>")
                                        .css({ color: "#888" })
                                        .text(String(_("Your name")))
                                )
                                .append(
                                    $("<br/>")
                                )
                                .append(
                                    $("<input/>")
                                        .attr({
                                            type: "text",
                                            id: "add-account-displayname",
                                            name: "personal",
                                            placeholder: String(_("Your name")),
                                            autocapitalize: "off",
                                            autocorrect: "off"
                                        })
                                        .val(displayName || "")
                                        .css({
                                            fontSize: "11pt",
                                            fontFamily: "monospace",
                                            padding: "0.20em",
                                            width: "20em"
                                        })
                                )
                        )
                        .append(
                            $("<div/>")
                                .css("marginTop", "0.5em")
                                .append(
                                    // password
                                    $("<label/>")
                                        .css({ color: "#888" })
                                        .text(String(_("Your password")))
                                )
                                .append(
                                    $("<br/>")
                                )
                                .append(
                                    password = $("<input/>")
                                        .attr({
                                            type: "password",
                                            id: "add-account-password",
                                            name: "password",
                                            placeholder: String(_("Your password")),
                                            autocapitalize: "off",
                                            autocorrect: "off"
                                        })
                                        .val("")
                                        .css({
                                            fontSize: "11pt",
                                            fontFamily: "monospace",
                                            padding: "0.20em",
                                            width: "20em"
                                        })
                                )
                        )
                )
                .append(
                    $("<div/>") // controls
                        .css({
                            margin: "1.5em 0 0 0"
                        })
                        .append(
                            $.button({
                                title: _("Add account"),
                                click: next
                            })
                                .addClass("default")
                                .css({ "float": "right", margin: "0 0 0 0.5em" })
                        )
                        .append(
                            $.button({
                                title: _("Back"),
                                data: { addr: addr },
                                click: back
                            })
                                .css({ "float": "right", margin: "0 0 0 0.5em" })
                        )
                        .append(
                            $.button({
                                title: _("Cancel"),
                                click: cancel
                            })
                                .css({ "float": "right", margin: "0 0 0 0.5em" })
                        )
                        .append(
                            $("<div/>").css("clear", "both")
                        )
                )
        );

    // show products
    if (numProducts(service) > 1) {
        // add label
        fields.append(
            $("<div/>")
                .css({ color: "#888", marginTop: "0.5em" })
                .text(String(_("Connection type / Product")))
        );
        // loop over products
        var id, products = service.products, product, i = 0;
        for (id in products) {
            product = products[id];
            fields.append(
                $.radio("add-account-product", id, (i++) === 0, product.name + "\u00a0\u00a0 ")
            );
        }
    }

    // add description?
    if (service.description) {
        fields.append(
            $("<div/>")
                .css({ margin: "1em 0 0 0" })
                .html(String(_(service.description)))
        );
    }

    node.popup({
        width: WIDTH,
        modal: true,
        center: true
    });

    password.focus();
};

var customService = function (addr) {

    var gotoSettings = function () {
        ox.UIController.configJump("configuration/mail/accounts", function() {
            new_mail_account({ primary_address: addr });
        });
        closePopup();
        return false;
    };
    
    // create second form
    form.empty()
        .unbind("submit")
        .bind("submit", false)
        .append(
            // mail address
            $("<div/>")
                .css({
                    fontFamily: "monospace",
                    fontSize: "11pt",
                    margin: "1.5em 0 1em 0",
                    whiteSpace: "nowrap",
                    overflow: "hidden",
                    textOverflow: "ellipsis"
                })
                .text(addr)
        )
        .append(
            $("<div/>")
                .text(
                    String(_("Your E-Mail provider cannot be configured automatically. Therefore, your E-Mail account requires a custom configuration of server settings.")) 
                )
        )
        .append(
            // controls
            $("<div/>")
                .css({ margin: "1.5em 0 0 0" })
                .append(
                    $.button({
                        title: _("Configure custom account"),
                        click: gotoSettings
                    })
                        .addClass("default")
                        .css({ "float": "right", margin: "0 0 0 0.5em" })
                )
                .append(
                    $.button({
                        title: _("Back"),
                        data: { addr: addr },
                        click: back
                    })
                        .css({ "float": "right", margin: "0 0 0 0.5em" })
                )
                .append(
                    $.button({
                        title: _("Cancel"),
                        click: cancel
                    })
                        .css({ "float": "right", margin: "0 0 0 0.5em" })
                )
                .append(
                    $("<div/>").css("clear", "both")
                )
        );
    
    node.popup({
        width: WIDTH,
        modal: true,
        center: true
    });
};

var autoDetect = function () {

    try {

        // get value
        var addr = $.trim(mail.val()).toLowerCase(),
            match = addr.match(rDomain),
            domain = "",
            accounts = ox.api.cache.account.values(),
            i = 0,
            $i = accounts.length,
            account;

        // invalid? -- not in term of RPC but good against typos
        if (!/^\S+@\S+\.\S+$/.test(addr)) {
            ox.UINotifier.warn(
                _("You have to enter a valid E-Mail address")
            );
            mail.focus();
            return false;
        }
        
        // look for duplicates
        for (; i < $i; i++) {
            account = accounts[i];
            if (addr === account.primary_address.toLowerCase()) {
                // email address already in use
                ox.UINotifier.warn(
                    format(_("The account '%1$s' already uses the given E-Mail address! It's not possible to use an E-Mail address more that once. If you haven't found the corresponding account, please look for an E-Mail folder named '%1$s' in the left sidepanel."), account.name)
                );
                mail.focus();
                return false;
            }
        }

        if (match && match.length) {
            // get domain
            domain = match[1];
            // find service
            var id, service;
            for (id in ox.mail.services) {
                service = ox.mail.services[id];
                if ($.inArray(domain, service.domains) > -1) {
                    // found - configure that service...
                    configureService(addr, service);
                    return false;
                }
            }
        }

        // continue with custom service
        customService(addr);

    } catch (e) {
        if (url.dev) {
            console.error(e.description);
        }
    }
    return false;
};

var getDisplayName = function (cb) {
    var identifier = config.identifier;
    internalCache.getUsers([identifier], function (data) {
        displayName = data[identifier].display_name;
        if (cb) { cb(); }
    });
};

var loadServices = function () {

    // join
    var join = new Join(ox.mail.addAccount),
        unlock = join.add();
    
    // load services first
    $.getScript(PATH + "/services/config.js", join.add(function () {
        // disable services via config?
        if (ox.api.config.contains("ui.mail.services.enabled")) {
            var list = ox.api.config.get("ui.mail.services.enabled"), id;
            for (id in ox.mail.services) {
                // enabled?
                if (list[id] !== true) {
                    // remove from static definition
                    delete ox.mail.services[id];
                }
            }
        }
        // extend services?
        if (ox.api.config.contains("ui.mail.services.extend")) {
            // extend
            jQuery.extend(true, ox.mail.services, ox.api.config.get("ui.mail.services.extend"));
        }
    }));
    
    // get display name
    getDisplayName(join.add());
    
    unlock();
};

ox.mail.addAccount = function (addr) {

    try {

        // get services?
        if (ox.mail.services === null) {
            loadServices();
            return;
        }

        if (node !== null) {
            node.empty();
        }

        // mail field
        mail = $("<input/>")
            .attr({
                type: IE ? "text" : "email",
                id: "add-account-email",
                name: "email",
                autocapitalize: "off",
                autocorrect: "off",
                placeholder: String(_("Your E-Mail address"))
            })
            .val(addr || "")
            .css({
                fontSize: "11pt",
                fontFamily: "monospace",
                padding: "0.20em",
                width: "25em"
            });

        // list services
        var services = $("<div/>")
            .css({ margin: "1em 0 1em 0", width: "30em" })
            .append(
                $("<span/>")
                    .text(
                        _("The following services can be configured automatically") + ":"
                    )
            )
            .append(
                $("<br/>")
            );

        var fnClick = function (e) {
            // get content
            var val = $.trim(mail.val()).replace(/@.*$/, ""), pre, pos;
            // preselect?
            if (mail.get(0).setSelectionRange) {
                if (val === "") {
                    pre = String(_("yourname"));
                    pos = pre.length;
                    mail.val(pre + "@" + e.data);
                } else {
                    mail.val(val + "@" + e.data);
                    pos = val.length;
                }
                mail.get(0).setSelectionRange(0, pos);
            } else {
                mail.val(val + "@" + e.data);
            }
            mail.focus();
            return false;
        };

        $.each(ox.mail.services, function (i, service) {
            $.each(service.domains, function (j, domain) {
                services
                    .append(
                        $("<a/>", { href: "#" })
                            .css("whiteSpace", "nowrap")
                            .text(domain)
                            .bind("click", domain, fnClick)
                    )
                    .append(
                        $("<span/>").text(",\u00a0 ")
                    );
            });
        });

        // remove last comma
        services.children().last().remove();

        node = $("<div/>", { id: "add-account-container" })
            .addClass("plain")
            .append(
                $("<h1/>")
                    .css({ marginTop: "0.5em", whiteSpace: "nowrap" })
                    .text(String(_("Add E-Mail account")))
            )
            .append(
                form = $("<form/>")
                    .css({ margin: "0" })
                    .bind("submit", autoDetect)
                    .bind("submit", false)
                    .append(
                        $("<label/>")
                            .css({ color: "#888" })
                            .text(String(_("Enter your E-Mail address")))
                    )
                    .append(
                        $("<br/>")
                    )
                    .append(mail)
                    .append(services)
                    .append(
                        // controls
                        $("<div/>")
                            .css({ margin: "10px 0 0 0" })
                            .append(
                                $.button({
                                    title: _("Next"),
                                    click: autoDetect
                                })
                                    .addClass("default")
                                    .css({ "float": "right", margin: "0 0 0 0.5em" })
                            )
                            .append(
                                $.button({
                                    title: _("Cancel"),
                                    click: cancel
                                })
                                    .css({ "float": "right", margin: "0 0 0 0.5em" })
                            )
                    )
                    .append($("<div/>").css("clear", "both"))
            );
        
        // get display name (async; cp. bug #20409)
        getDisplayName(function () {
            node.popup({
                width: WIDTH,
                modal: true,
                center: true
            });
            
            mail.focus();
        });

    } catch (e) {
        if (url.dev) {
            console.error(e.description);
        }
    }
};

