
/* 
 * Default values:
 * transport_protocol: "smtp"
 * transport_secure: true (just ssl; not TSL)
 * transport_port: 25 or 465 (ssl)
 * transport_auth: false
 * transport_auth_short: false (strip off the domain part)
 * mail_protocol: "pop3"
 * mail_secure: true
 * mail_port: 110 (pop3), 995 (pop3/ssl), 143 (imap), 993 (imap/ssl)
 * mail_auth_short: false 
 */

// This is a preliminary feature.
// The configuration structure might be subject to change.

ox.mail.services = {

    gmail: {
        // Google Mail
        name: "Google Mail",
        domains: ["gmail.com", "googlemail.com"],
        products: {
            imap: {
                name: "IMAP",
                transport_server: "smtp.gmail.com",
                mail_protocol: "imap",
                mail_server: "imap.gmail.com"
            },
            pop: {
                name: "POP3",
                transport_server: "smtp.gmail.com",
                mail_server: "pop.gmail.com"
            }
        },
        description: "In order to use your GMail account, you have to enable POP3 or IMAP support. Please log in to <a href='https://mail.google.com/mail' target='gmail'>GMail</a> first. Afterwards, please adjust your <a href='https://mail.google.com/mail/#settings/fwdandpop' target='gmail'>settings</a>.", /*i18n*/
        logo: {
            src: "gmail.png",
            height: "59px"
        }
    },

    gmx_com: {
        // GMX USA
        name: "GMX.com FreeMail",
        domains: ["gmx.com"],
        products: {
            imap: {
                name: "IMAP",
                transport_server: "mail.gmx.com",
                transport_secure: false,
                transport_auth: true,
                mail_protocol: "imap",
                mail_server: "imap.gmx.com",
                mail_secure: false
            },
            pop: {
                name: "POP3",
                transport_server: "mail.gmx.com",
                transport_secure: false,
                transport_auth: true,
                mail_server: "pop.gmx.com",
                mail_secure: false
            }
        }
    },
    
    gmx_de: {
        // GMX Germany
        name: "GMX.de FreeMail",
        domains: ["gmx.de"],
        products: {
            imap: {
                name: "IMAP",
                transport_server: "mail.gmx.net",
                transport_port: 465,
                transport_secure: true,
                transport_auth: true,
                mail_protocol: "imap",
                mail_server: "imap.gmx.net",
                mail_secure: true
            },
            pop: {
                name: "POP3",
                transport_server: "mail.gmx.net",
                transport_port: 465,
                transport_secure: true,
                transport_auth: true,
                mail_server: "pop.gmx.net",
                mail_secure: true
            }
        }
    },
    
    t_online: {
        // T-Online
        name: "T-Online",
        domains: ["t-online.de"],
        products: {
            pop: {
                name: "Free Mail",
                transport_server: "securesmtp.t-online.de",
                transport_secure: false,
                transport_port: 587,
                transport_auth: true,
                mail_server: "securepop.t-online.de",
                mail_secure: false
            }
        },
        description: "In order to use your account via POP3, you have to set a specific password in your <a href='https://kundencenter.telekom.de/kundencenter/kundendaten/passwoerter/email-passwort-einrichten.html' target='_blank'>customer center</a>.", /*i18n*/
        color: "#E20074"
    },
    
    yahoo: {
        // Yahoo Mail
        name: "Yahoo! Mail",
        domains: ["yahoo.com", "yahoo.de"],
        products: {
            imap: {
            	name: "IMAP",
                transport_server: "smtp.mail.yahoo.com",
                transport_auth: true,
                mail_server: "imap.mail.yahoo.com",
                mail_protocol: "imap",
                mail_secure: true
            },
    		pop: {
    			name: "POP3",
    			transport_server: "smtp.mail.yahoo.com",
    			transport_auth: true,
    			mail_server: "pop.mail.yahoo.com"
    		}
        },
        description: "You might need a Yahoo! Plus Upgrade in your country in order to access your account via POP3.", /*i18n*/
        color: "#9A1FB6",
        logo: {
            src: "yahoo.gif",
            height: "26px",
            margin: "0.5em 0 1em 0"
        }
    },

    msn: {
        // Windows Live
        name: "Windows Live",
        domains: ["hotmail.de", "hotmail.com", "msn.com", "live.com"],
        products: {
            pop: {
                name: "Free Mail",
                transport_server: "smtp.live.com",
                transport_port: 25,
                transport_auth: true,
                transport_secure: false,
                mail_server: "pop3.live.com",
                mail_secure: true
            }
        },
        logo: {
            src: "windowslive.png",
            height: "23px",
            margin: "0.5em 0 1.5em 0"
        }
    },

    web_de: {
        // Web.de
        name: "web.de",
        domains: ["web.de"],
        products: {
            imap: {
                name: "IMAP",
                transport_server: "smtp.web.de",
                transport_auth: true,
                transport_auth_short: true,
                transport_secure: false,
                mail_protocol: "imap",
                mail_server: "imap.web.de",
                mail_auth_short: true
            }
        },
        color: "#fb0",
        logo: {
            src: "webde.gif",
            height: "58px",
            margin: "0.5em 0 1em 0"
        }
    },
    
    freenet: {
        // Web.de
        name: "freenet mail",
        domains: ["freenet.de"],
        products: {
            imap: {
                name: "IMAP",
                transport_server: "mx.freenet.de",
                transport_auth: true,
                transport_secure: false,
                mail_protocol: "imap",
                mail_server: "mx.freenet.de",
                mail_secure: false
            }
        },
        color: "#A0D82C"
    }
};
