/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2011 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 */

/* This plugin can be used to try out translations without compiling new
 * packages.
 */

register("Ready", function() {

    var node = new ox.Configuration.LeafNode(
        "configuration/com.openexchange.potest", _("PO Test"));
    var page = new ox.Configuration.Page(node, _("PO Test"));
    page.init = function() {
        page.addWidget(new ox.UI.Text(
            _("This page allows you to test a new translation by uploading a PO file.")));
        page.addWidget(new ox.UI.Text(
            _("The new PO file takes effect immediately.")));
    
        var file = new ox.UI.Widget();
        file.label = _("PO file for upload");
        file.addContent = function(node_id) {
            this.form = newnode("form", 0, {
                action: AjaxRoot +
                    "/file?action=new&module=mail&type=text&session=" + session,
                method: "post",
                enctype: "multipart/form-data",
                target: "dlIframe"
            }, [newnode("input", 0, { type: "file",
                                      id: "com.openexchange.potest.file",
                                      name: "com.openexchange.potest.file" })]);
            this.node = this.parent.addCells(this.label, this.form);
        };
        file.upload = function(cont) {
            var useBackup = "callback_new" in window;
            if (useBackup) var backup = window.callback_new;
            window.callback_new = function(reply) {
                if (useBackup) {
                    window.callback_new = backup;
                } else {
                    delete window.callback_new;
                }
                if (reply.error) {
                    ox.Configuration.error(formatError(reply));
                } else {
                    cont(reply.data);
                }
            };
            this.form.submit();
        };
        page.addWidget(file);
        
        var domain = new ox.UI.ComboBox(_("Plugin name"));
        var domains = listI18nDomains(), names = listI18nDomains();
        names[0] = _("Core GUI");
        domain.setEntries(domains, names);
        page.addWidget(domain);
        
        page.toolbar = temporary.configuration.newToolbar(_("PO Test"),
            [{ title: _("PO Test"), buttons: [{
                title: _("Upload"), icons: ["img/menu/btn_save.gif"], big: true,
                action: upload
            }] }]);
        
        function upload() {
            file.upload(function(ids) {
                ox.JSON.get(AjaxRoot + "/file?action=get&id=" + ids[0] +
                            "&session=" + session, install, null, true);
            });
        }
        
        function install(file) {
            try {
                replacePOFile(domain.get(), "com.openexchange.potest", file);
                setLanguage("com.openexchange.potest");
            } catch (e) {
                ox.Configuration.error(e.message);
            }
        }
        
    };
    
    all_languages["com.openexchange.potest"] = _("custom PO file");
    
});
