/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.sort.NodeOrderComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class DocumentSorter
extends UnaryExpression {
    private NodeOrderComparer comparer;

    public DocumentSorter(Expression expression) {
        super(expression);
        int n = expression.getSpecialProperties();
        this.comparer = (n & 0x10000) != 0 || (n & 0x800000) != 0 ? LocalOrderComparer.getInstance() : GlobalOrderComparer.getInstance();
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if ((this.operand.getSpecialProperties() & 0x20000) != 0) {
            if (this.operand instanceof ComputedExpression) {
                ((ComputedExpression)this.operand).setParentExpression(this.getParentExpression());
            }
            return this.operand;
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.optimize(optimizer, staticContext, itemType);
        if ((this.operand.getSpecialProperties() & 0x20000) != 0) {
            if (this.operand instanceof ComputedExpression) {
                ((ComputedExpression)this.operand).setParentExpression(this.getParentExpression());
            }
            return this.operand;
        }
        return this;
    }

    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties() | 0x20000;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.operand = this.doPromotion(this.operand, promotionOffer);
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return new DocumentOrderIterator(this.operand.iterate(xPathContext), this.comparer);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return this.operand.effectiveBooleanValue(xPathContext);
    }

    protected String displayOperator(Configuration configuration) {
        if (this.comparer instanceof LocalOrderComparer) {
            return "intra-document sort and deduplicate";
        }
        return "sort and deduplicate";
    }
}

