/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.platform;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.Execute;

public class Platform {
    public static final int FAMILY_NONE = 0;
    public static final int FAMILY_UNIX = 1;
    public static final int FAMILY_WINDOWS = 2;
    public static final int FAMILY_OS2 = 3;
    public static final int FAMILY_ZOS = 4;
    public static final int FAMILY_OS400 = 5;
    public static final int FAMILY_DOS = 6;
    public static final int FAMILY_MAC = 7;
    public static final int FAMILY_MACOSX = 8;
    public static final int FAMILY_TANDEM = 9;
    public static final int FAMILY_OPENVMS = 10;
    public static final String FAMILY_NAME_UNIX = "unix";
    public static final String FAMILY_NAME_WINDOWS = "windows";
    public static final String FAMILY_NAME_OS2 = "os/2";
    public static final String FAMILY_NAME_ZOS = "z/os";
    public static final String FAMILY_NAME_OS400 = "os/400";
    public static final String FAMILY_NAME_DOS = "dos";
    public static final String FAMILY_NAME_MAC = "mac";
    public static final String FAMILY_NAME_TANDEM = "tandem";
    public static final String FAMILY_NAME_OPENVMS = "openvms";
    private static final Hashtable familyNames = new Hashtable();

    public static final int getOsFamily() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("path.separator");
        int n = 0;
        if (string.indexOf(FAMILY_NAME_WINDOWS) != -1) {
            n = 2;
        } else if (string.indexOf(FAMILY_NAME_OS2) != -1) {
            n = 3;
        } else if (string.indexOf(FAMILY_NAME_ZOS) != -1 || string.indexOf("os/390") != -1) {
            n = 4;
        } else if (string.indexOf(FAMILY_NAME_OS400) != -1) {
            n = 5;
        } else if (string2.equals(";")) {
            n = 6;
        } else if (string.indexOf(FAMILY_NAME_MAC) != -1) {
            n = string.endsWith("x") ? 1 : 7;
        } else if (string.indexOf("nonstop_kernel") != -1) {
            n = 9;
        } else if (string.indexOf(FAMILY_NAME_OPENVMS) != -1) {
            n = 10;
        } else if (string2.equals(":")) {
            n = 1;
        }
        return n;
    }

    public static final String getOsFamilyName() {
        int n = Platform.getOsFamily();
        return (String)familyNames.get(new Integer(n));
    }

    public static final Properties getEnv() {
        Properties properties = new Properties();
        Vector vector = Execute.getProcEnvironment();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = string.indexOf(61);
            if (n == -1) continue;
            properties.setProperty(string.substring(0, n), string.substring(n + 1));
        }
        return properties;
    }

    public static final String getDefaultShell() {
        String string = Platform.getEnv().getProperty("SHELL");
        if (string == null) {
            int n = Platform.getOsFamily();
            switch (n) {
                case 2: 
                case 6: {
                    string = "CMD.EXE";
                    break;
                }
                default: {
                    string = "bash";
                }
            }
        }
        return string;
    }

    public static final String getDefaultScriptSuffix() {
        int n = Platform.getOsFamily();
        String string = null;
        switch (n) {
            case 2: 
            case 6: {
                string = ".bat";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public static final String[] getDefaultShellArguments() {
        int n = Platform.getOsFamily();
        String[] stringArray = null;
        switch (n) {
            case 2: 
            case 6: {
                stringArray = new String[]{"/c", "call"};
                break;
            }
            default: {
                stringArray = new String[]{};
            }
        }
        return stringArray;
    }

    static {
        familyNames.put(new Integer(2), FAMILY_NAME_WINDOWS);
        familyNames.put(new Integer(3), FAMILY_NAME_OS2);
        familyNames.put(new Integer(4), FAMILY_NAME_ZOS);
        familyNames.put(new Integer(5), FAMILY_NAME_OS400);
        familyNames.put(new Integer(6), FAMILY_NAME_DOS);
        familyNames.put(new Integer(7), FAMILY_NAME_MAC);
        familyNames.put(new Integer(8), FAMILY_NAME_UNIX);
        familyNames.put(new Integer(9), FAMILY_NAME_TANDEM);
        familyNames.put(new Integer(1), FAMILY_NAME_UNIX);
        familyNames.put(new Integer(10), FAMILY_NAME_OPENVMS);
    }
}

