/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class XMLEmitter
extends Emitter {
    protected boolean empty = true;
    protected boolean openStartTag = false;
    protected boolean declarationIsWritten = false;
    protected int elementCode;
    protected boolean preferHex = false;
    protected boolean undeclareNamespaces = false;
    private boolean warningIssued = false;
    protected Stack elementStack = new Stack();
    private String[] nameLookup = new String[2048];
    private boolean indenting = false;
    private int indentSpaces = 3;
    private String indentChars = "\n                                                          ";
    private int totalAttributeLength = 0;
    private boolean requireWellFormed = false;
    static boolean[] specialInText;
    static boolean[] specialInAtt;
    private char[] charref = new char[10];

    public void open() throws XPathException {
    }

    public void startDocument(int n) throws XPathException {
    }

    public void endDocument() throws XPathException {
        if (!this.elementStack.isEmpty()) {
            throw new IllegalStateException("Attempt to end document in serializer when elements are unclosed");
        }
    }

    protected void openDocument() throws XPathException {
        String string;
        if (this.writer == null) {
            this.makeWriter();
        }
        if (this.characterSet == null) {
            this.characterSet = UnicodeCharacterSet.getInstance();
        }
        if ((string = this.outputProperties.getProperty("{http://saxon.sf.net/}character-representation")) != null) {
            this.preferHex = string.trim().equalsIgnoreCase("hex");
        }
        if ((string = this.outputProperties.getProperty("undeclare-prefixes")) != null) {
            this.undeclareNamespaces = string.trim().equalsIgnoreCase("yes");
        }
        this.writeDeclaration();
    }

    public void writeDeclaration() throws XPathException {
        if (this.declarationIsWritten) {
            return;
        }
        this.declarationIsWritten = true;
        try {
            String string;
            String string2;
            String string3;
            String string4;
            this.indenting = "yes".equals(this.outputProperties.getProperty("indent"));
            String string5 = this.outputProperties.getProperty("{http://saxon.sf.net/}indent-spaces");
            if (string5 != null) {
                try {
                    this.indentSpaces = Integer.parseInt(string5.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ("yes".equals(string4 = this.outputProperties.getProperty("byte-order-mark")) && "UTF-8".equalsIgnoreCase(this.outputProperties.getProperty("encoding"))) {
                this.writer.write(65279);
            }
            if ((string3 = this.outputProperties.getProperty("omit-xml-declaration")) == null) {
                string3 = "no";
            }
            if ((string2 = this.outputProperties.getProperty("version")) == null) {
                string2 = this.getConfiguration().getNameChecker().getXMLVersion();
            } else {
                if (!string2.equals("1.0") && !string2.equals("1.1")) {
                    DynamicError dynamicError = new DynamicError("XML version must be 1.0 or 1.1");
                    dynamicError.setErrorCode("SESU0006");
                    throw dynamicError;
                }
                if (!string2.equals("1.0") && string3.equals("yes") && this.outputProperties.getProperty("doctype-system") != null) {
                    DynamicError dynamicError = new DynamicError("Values of 'version', 'omit-xml-declaration', and 'doctype-system' conflict");
                    dynamicError.setErrorCode("SEPM0009");
                    throw dynamicError;
                }
            }
            if (string2.equals("1.0") && this.undeclareNamespaces) {
                DynamicError dynamicError = new DynamicError("Cannot undeclare namespaces with XML version 1.0");
                dynamicError.setErrorCode("SEPM0010");
                throw dynamicError;
            }
            String string6 = this.outputProperties.getProperty("encoding");
            if (string6 == null || string6.equalsIgnoreCase("utf8")) {
                string6 = "UTF-8";
            }
            if ("omit".equals(string = this.outputProperties.getProperty("standalone"))) {
                string = null;
            }
            if (string != null) {
                this.requireWellFormed = true;
                if (string3.equals("yes")) {
                    DynamicError dynamicError = new DynamicError("Values of 'standalone' and 'omit-xml-declaration' conflict");
                    dynamicError.setErrorCode("SEPM0009");
                    throw dynamicError;
                }
            }
            if (string3.equals("no")) {
                this.writer.write("<?xml version=\"" + string2 + "\" " + "encoding=\"" + string6 + '\"' + (string != null ? " standalone=\"" + string + '\"' : "") + "?>");
            }
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    protected void writeDocType(String string, String string2, String string3) throws XPathException {
        try {
            if (this.declarationIsWritten && !this.indenting) {
                this.writer.write("\n");
            }
            this.writer.write("<!DOCTYPE " + string + '\n');
            if (string2 != null && string3 == null) {
                this.writer.write("  SYSTEM \"" + string2 + "\">\n");
            } else if (string2 == null && string3 != null) {
                this.writer.write("  PUBLIC \"" + string3 + "\">\n");
            } else {
                this.writer.write("  PUBLIC \"" + string3 + "\" \"" + string2 + "\">\n");
            }
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    public void close() throws XPathException {
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        if (this.empty) {
            this.openDocument();
        } else if (this.requireWellFormed && this.elementStack.isEmpty()) {
            DynamicError dynamicError = new DynamicError("When 'standalone' or 'doctype-system' is specified, the document must be well-formed; but this document contains more than one top-level element");
            dynamicError.setErrorCode("SEPM0004");
            throw dynamicError;
        }
        String string = null;
        if (n < 2048) {
            string = this.nameLookup[n];
        }
        if (string == null) {
            int n5;
            string = this.namePool.getDisplayName(n);
            if (n < 2048) {
                this.nameLookup[n] = string;
            }
            if ((n5 = this.testCharacters(string)) != 0) {
                DynamicError dynamicError = new DynamicError("Element name contains a character (decimal + " + n5 + ") not available in the selected encoding");
                dynamicError.setErrorCode("SERE0008");
                throw dynamicError;
            }
        }
        this.elementStack.push(string);
        this.elementCode = n;
        try {
            if (this.empty) {
                String string2 = this.outputProperties.getProperty("doctype-system");
                String string3 = this.outputProperties.getProperty("doctype-public");
                if (string2 != null) {
                    this.requireWellFormed = true;
                    this.writeDocType(string, string2, string3);
                }
                this.empty = false;
            }
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write(60);
            this.writer.write(string);
            this.openStartTag = true;
            this.totalAttributeLength = 0;
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    public void namespace(int n, int n2) throws XPathException {
        try {
            String string = this.namePool.getPrefixFromNamespaceCode(n);
            String string2 = this.namePool.getURIFromNamespaceCode(n);
            int n3 = string2.length() + string.length() + 8;
            String string3 = " ";
            if (this.indenting && this.totalAttributeLength + n3 > 80 && this.totalAttributeLength != 0) {
                string3 = this.getAttributeIndentString();
            }
            this.totalAttributeLength += n3;
            if (string.equals("")) {
                this.writer.write(string3);
                this.writeAttribute(this.elementCode, "xmlns", string2, 0);
            } else {
                if (string.equals("xml")) {
                    return;
                }
                int n4 = this.testCharacters(string);
                if (n4 != 0) {
                    DynamicError dynamicError = new DynamicError("Namespace prefix contains a character (decimal + " + n4 + ") not available in the selected encoding");
                    dynamicError.setErrorCode("SERE0008");
                    throw dynamicError;
                }
                if (this.undeclareNamespaces || !string2.equals("")) {
                    this.writer.write(string3);
                    this.writeAttribute(this.elementCode, "xmlns:" + string, string2, 0);
                }
            }
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        int n5;
        String string = null;
        if (n < 2048) {
            string = this.nameLookup[n];
        }
        if (string == null) {
            string = this.namePool.getDisplayName(n);
            if (n < 2048) {
                this.nameLookup[n] = string;
            }
            if ((n5 = this.testCharacters(string)) != 0) {
                DynamicError dynamicError = new DynamicError("Attribute name contains a character (decimal + " + n5 + ") not available in the selected encoding");
                dynamicError.setErrorCode("SERE0008");
                throw dynamicError;
            }
        }
        n5 = string.length() + charSequence.length() + 4;
        String string2 = " ";
        if (this.indenting && this.totalAttributeLength + n5 > 80 && this.totalAttributeLength != 0) {
            string2 = this.getAttributeIndentString();
        }
        this.totalAttributeLength += n5;
        try {
            this.writer.write(string2);
            this.writeAttribute(this.elementCode, string, charSequence, n4);
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    private String getAttributeIndentString() {
        int n = (this.elementStack.size() - 1) * this.indentSpaces + ((String)this.elementStack.peek()).length() + 3;
        while (n >= this.indentChars.length()) {
            this.indentChars = this.indentChars + "                     ";
        }
        return this.indentChars.substring(0, n);
    }

    public void startContent() throws XPathException {
    }

    public void closeStartTag() throws XPathException {
        try {
            if (this.openStartTag) {
                this.writer.write(62);
                this.openStartTag = false;
            }
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    protected String emptyElementTagCloser(String string, int n) {
        return "/>";
    }

    protected void writeAttribute(int n, String string, CharSequence charSequence, int n2) throws XPathException {
        try {
            String string2 = ((Object)charSequence).toString();
            this.writer.write(string);
            if ((n2 & 4) != 0) {
                this.writer.write(61);
                this.writer.write(34);
                this.writer.write(string2);
                this.writer.write(34);
            } else if ((n2 & 0x100) != 0) {
                this.writer.write(61);
                int n3 = string2.indexOf(34) >= 0 ? 39 : 34;
                this.writer.write(n3);
                this.writeEscape(charSequence, true);
                this.writer.write(n3);
            } else {
                this.writer.write("=\"");
                this.writeEscape(charSequence, true);
                this.writer.write(34);
            }
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    protected int testCharacters(CharSequence charSequence) throws XPathException {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c <= '\u007f') continue;
            if (XMLChar.isHighSurrogate(c)) {
                int n;
                if (this.characterSet.inCharset(n = XMLChar.supplemental(c, charSequence.charAt(++i)))) continue;
                return n;
            }
            if (this.characterSet.inCharset(c)) continue;
            return c;
        }
        return 0;
    }

    public void endElement() throws XPathException {
        String string = (String)this.elementStack.pop();
        try {
            if (this.openStartTag) {
                this.writer.write(this.emptyElementTagCloser(string, this.elementCode));
                this.openStartTag = false;
            } else {
                this.writer.write("</");
                this.writer.write(string);
                this.writer.write(62);
            }
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        block15: {
            if (this.empty) {
                this.openDocument();
                if (!Whitespace.isWhite(charSequence) && (this.requireWellFormed || this.outputProperties.getProperty("doctype-system") != null)) {
                    DynamicError dynamicError = new DynamicError("When 'standalone' or 'doctype-system' is specified, the document must be well-formed; but this document contains a top-level text node");
                    dynamicError.setErrorCode("SEPM0004");
                    throw dynamicError;
                }
            }
            if (this.requireWellFormed && this.elementStack.isEmpty() && !Whitespace.isWhite(charSequence)) {
                DynamicError dynamicError = new DynamicError("When 'standalone' or 'doctype-system' is specified, the document must be well-formed; but this document contains a top-level text node");
                dynamicError.setErrorCode("SEPM0004");
                throw dynamicError;
            }
            try {
                if (this.openStartTag) {
                    this.closeStartTag();
                }
                if ((n2 & 4) != 0) {
                    this.writeCharSequence(charSequence);
                    break block15;
                }
                if ((n2 & 1) == 0) {
                    this.writeEscape(charSequence, false);
                    break block15;
                }
                if (this.testCharacters(charSequence) == 0) {
                    if ((n2 & 0x100) == 0) {
                        this.writeCharSequence(charSequence);
                    } else {
                        int n3 = charSequence.length();
                        for (int i = 0; i < n3; ++i) {
                            char c = charSequence.charAt(i);
                            if (c == '\u0000') continue;
                            this.writer.write(c);
                        }
                    }
                    break block15;
                }
                if (!this.warningIssued) {
                    try {
                        this.getPipelineConfiguration().getErrorListener().warning(new TransformerException("disable-output-escaping is ignored for characters not available in the chosen encoding"));
                    }
                    catch (TransformerException transformerException) {
                        throw DynamicError.makeDynamicError(transformerException);
                    }
                    this.warningIssued = true;
                }
                this.writeEscape(charSequence, false);
            }
            catch (IOException iOException) {
                throw new DynamicError(iOException);
            }
        }
    }

    public void writeCharSequence(CharSequence charSequence) throws IOException {
        if (charSequence instanceof String) {
            this.writer.write((String)charSequence);
        } else if (charSequence instanceof CharSlice) {
            ((CharSlice)charSequence).write(this.writer);
        } else if (charSequence instanceof FastStringBuffer) {
            ((FastStringBuffer)charSequence).write(this.writer);
        } else if (charSequence instanceof CompressedWhitespace) {
            ((CompressedWhitespace)charSequence).write(this.writer);
        } else {
            this.writer.write(((Object)charSequence).toString());
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        int n3;
        if (this.empty) {
            this.openDocument();
        }
        if ((n3 = this.testCharacters(string)) != 0) {
            DynamicError dynamicError = new DynamicError("Character in processing instruction name cannot be represented in the selected encoding (code " + n3 + ')');
            dynamicError.setErrorCode("SERE0008");
            throw dynamicError;
        }
        n3 = this.testCharacters(charSequence);
        if (n3 != 0) {
            DynamicError dynamicError = new DynamicError("Character in processing instruction data cannot be represented in the selected encoding (code " + n3 + ')');
            dynamicError.setErrorCode("SERE0008");
            throw dynamicError;
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write("<?" + string + (charSequence.length() > 0 ? ' ' + ((Object)charSequence).toString() : "") + "?>");
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    protected void writeEscape(CharSequence charSequence, boolean bl) throws IOException, XPathException {
        boolean[] blArray;
        int n = 0;
        boolean bl2 = false;
        boolean[] blArray2 = blArray = bl ? specialInAtt : specialInText;
        if (charSequence instanceof CompressedWhitespace) {
            ((CompressedWhitespace)charSequence).writeEscape(blArray, this.writer);
            return;
        }
        while (n < charSequence.length()) {
            char c;
            int n2 = n;
            while (n2 < charSequence.length()) {
                c = charSequence.charAt(n2);
                if (c < '\u007f') {
                    if (blArray[c]) break;
                    ++n2;
                    continue;
                }
                if (c < '\u00a0' || c == '\u2028' || XMLChar.isHighSurrogate(c) || !this.characterSet.inCharset(c)) break;
                ++n2;
            }
            if (n2 >= charSequence.length()) {
                if (n == 0) {
                    this.writeCharSequence(charSequence);
                } else {
                    this.writeCharSequence(charSequence.subSequence(n, n2));
                }
                return;
            }
            if (n2 > n) {
                this.writeCharSequence(charSequence.subSequence(n, n2));
            }
            if ((c = charSequence.charAt(n2)) == '\u0000') {
                bl2 = !bl2;
            } else if (bl2) {
                this.writer.write(c);
            } else if (c >= '\u007f' && c < '\u00a0') {
                this.outputCharacterReference(c);
            } else if (c >= '\u00a0') {
                if (c == '\u2028') {
                    this.outputCharacterReference(c);
                } else if (XMLChar.isHighSurrogate(c)) {
                    char c2;
                    int n3;
                    if (this.characterSet.inCharset(n3 = XMLChar.supplemental(c, c2 = charSequence.charAt(++n2)))) {
                        this.writer.write(c);
                        this.writer.write(c2);
                    } else {
                        this.outputCharacterReference(n3);
                    }
                } else {
                    this.outputCharacterReference(c);
                }
            } else if (c == '<') {
                this.writer.write("&lt;");
            } else if (c == '>') {
                this.writer.write("&gt;");
            } else if (c == '&') {
                this.writer.write("&amp;");
            } else if (c == '\"') {
                this.writer.write("&#34;");
            } else if (c == '\n') {
                this.writer.write("&#xA;");
            } else if (c == '\r') {
                this.writer.write("&#xD;");
            } else if (c == '\t') {
                this.writer.write("&#x9;");
            } else {
                this.outputCharacterReference(c);
            }
            n = ++n2;
        }
    }

    protected void outputCharacterReference(int n) throws IOException {
        if (this.preferHex) {
            int n2 = 0;
            this.charref[n2++] = 38;
            this.charref[n2++] = 35;
            this.charref[n2++] = 120;
            String string = Integer.toHexString(n);
            int n3 = string.length();
            for (int i = 0; i < n3; ++i) {
                this.charref[n2++] = string.charAt(i);
            }
            this.charref[n2++] = 59;
            this.writer.write(this.charref, 0, n2);
        } else {
            int n4 = 0;
            this.charref[n4++] = 38;
            this.charref[n4++] = 35;
            String string = Integer.toString(n);
            int n5 = string.length();
            for (int i = 0; i < n5; ++i) {
                this.charref[n4++] = string.charAt(i);
            }
            this.charref[n4++] = 59;
            this.writer.write(this.charref, 0, n4);
        }
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        int n3;
        if (this.empty) {
            this.openDocument();
        }
        if ((n3 = this.testCharacters(charSequence)) != 0) {
            DynamicError dynamicError = new DynamicError("Character in comment cannot be represented in the selected encoding (code " + n3 + ')');
            dynamicError.setErrorCode("SERE0008");
            throw dynamicError;
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write("<!--");
            this.writer.write(((Object)charSequence).toString());
            this.writer.write("-->");
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        StreamResult streamResult = new StreamResult(new CharArrayWriter());
        XMLEmitter xMLEmitter = new XMLEmitter();
        xMLEmitter.setStreamResult(streamResult);
        StreamSource streamSource = new StreamSource(new File("c:\\temp\\test.xml"));
        System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Templates templates = transformerFactory.newTemplates(new StreamSource(new File("c:\\temp\\test.xsl")));
        templates.newTransformer().transform(streamSource, xMLEmitter);
    }

    static {
        int n;
        specialInText = new boolean[128];
        for (n = 0; n <= 31; ++n) {
            XMLEmitter.specialInText[n] = true;
        }
        for (n = 32; n <= 127; ++n) {
            XMLEmitter.specialInText[n] = false;
        }
        XMLEmitter.specialInText[0] = true;
        XMLEmitter.specialInText[10] = false;
        XMLEmitter.specialInText[9] = false;
        XMLEmitter.specialInText[13] = true;
        XMLEmitter.specialInText[60] = true;
        XMLEmitter.specialInText[62] = true;
        XMLEmitter.specialInText[38] = true;
        specialInAtt = new boolean[128];
        for (n = 0; n <= 15; ++n) {
            XMLEmitter.specialInAtt[n] = true;
        }
        for (n = 16; n <= 127; ++n) {
            XMLEmitter.specialInAtt[n] = false;
        }
        XMLEmitter.specialInAtt[0] = true;
        XMLEmitter.specialInAtt[13] = true;
        XMLEmitter.specialInAtt[10] = true;
        XMLEmitter.specialInAtt[9] = true;
        XMLEmitter.specialInAtt[60] = true;
        XMLEmitter.specialInAtt[62] = true;
        XMLEmitter.specialInAtt[38] = true;
        XMLEmitter.specialInAtt[34] = true;
    }
}

