/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

function ConfigPortalExternal() {
    this.grid, this.selection = new Selection();
    this.storage = new Storage(0, [], 0, 0, 0, 0, function(data) { return data.id; }); 
}

ConfigPortalExternal.prototype = {
        initGrid : function() {
            var self = this;
            var _selection = new Selection();
            _selection.oldToggle = _selection.toggle;
            _selection.selectable = function(index) {
                var data = this.storage.data.get(this.storage.getSID(index));
                // fake selection, disabled when protected
                return Boolean(!data["protected"]);
            };
            _selection.toggle = function(index) {
                return this.selectable(index) && this.oldToggle(index);
            };
            _selection.select = function(from, to) {
                for (var i = from; i < to; i++) {
                    if (!this.get(i) && this.selectable(i)) {
                        this.oldToggle(i);
                    }
                }
            };
            this.selection = _selection;
            
            // grid columns
            var gridColumns = [];
            // Title
            gridColumns.push({ 
                i18n: "description", /*i18n context*/
                text: "Title", /*i18n*/
                width: "25%",
                set: function (div, data) {
                    removeChildNodes(div);
                    div.appendChild(document.createTextNode(data.title || ""));
                    // protected, then text is silver
                    jQuery(div).parent().css({ color: (data["protected"] ? "silver" : "") });
                },
                clear: LiveGrid.makeClear("")
            });
            // URI - don't show if custom widgets are disabled
            if (ox.api.config.get("ui.portal.customUWA", true) === true) {
                gridColumns.push({
                    text: "URI", /*i18n*/
                    i18n: true,
                    set: function (div, data) {
                        removeChildNodes(div);
                        div.appendChild(document.createTextNode(data.url || ""));
                    },
                    clear: LiveGrid.makeClear("")
                });
            }
            // Visibility
            gridColumns.push({
                text: "Visibility", /*i18n*/
                i18n: true,
                width: "9em",
                set: function  (div, data) {
                    removeChildNodes(div);
                    div.appendChild(document.createTextNode(data.visible ? _("enabled") :_("disabled")));
                },
                clear: LiveGrid.makeClear("")
            });
            
            this.grid = new LiveGrid(gridColumns, this.selection);
            
            this.grid.emptylivegridtext = "";
            this.grid.events.register("Selected", function(ids2) {
                var ids = self.grid.selection.getSelected();
                ox.ToolBarController.processSelection("portal-external", false, ids);
            });
            
            this.grid.events.register("Activated", function(ids) {
                if (ox.api.config.get("ui.portal.customUWA", true) === true 
                		&& ids && ids.length > 0) {
                    triggerEvent("OX_Configuration_Edit_External");
                }
            });
            
            $("lg_header_uwa_modules").appendChild(this.grid.getHeader());
            this.grid.getTable($("lg_uwa_modules"));
    },
    
    enableGrid : function() {
        var Self = this;
        cnf_PE.storage.remove(0, cnf_PE.storage.ids.length);
        ox.uwa.list(function(data) {
            Self.storage.append(data);
            Self.grid.enable(Self.storage);
        });
    }, 
    
    disableGrid : function() {
        this.grid.disable();
    },
    
    addUWA : function() {
        cnf_PE.dialog.open(null, cnf_PE.storeUWA);
    },
    
    editUWA : function(isNew) {
        if (!isNew && ox.api.config.get("ui.portal.customUWA", true) === true) {
            var id = cnf_PE.grid.selection.getSelected()[0];
            if (id) {
                var obj = cnf_PE.grid.storage.data.data[id];
                if (obj) {
                    cnf_PE.dialog.open(obj, cnf_PE.storeUWA);
                }
            }
        }
    },
    
    activate: function(visible) {
        if (visible == undefined) {
            visible = true;
        }
        var selected = cnf_PE.grid.selection.getSelected();
        if (selected.length != 0) {
            cnf_PE.grid.storage.newIterate(selected, emptyFunction, function(id, obj) {
                obj.visible = visible;
                cnf_PE.storeUWA(obj);
            });
        }
    }, 
    
    deactivate: function() {
        cnf_PE.activate(false);
    },
    
    dialog : (function() {
        var final_cb;
        
        return {
            open : function(uwa, cb) {
                var color;
                final_cb = cb;
                
                if (uwa) {
                    $("external_window_uwa_id").value = uwa.id || uwa.name || "";
                    $("external_window_uwa_name").value = uwa.title || "";
                    $("external_autorefresh").checked = Boolean(uwa.autorefresh);
                    $("external_window_uwa_uri").value = uwa.url || "";
                    $("external_window_uwa_params").value = ox.uwa.util.convertParameters(uwa.parameters) || "";
                    $("external_standalone").checked = Boolean(uwa.standalone);
                }
                
                if (!ox.api.isModal()) {
                    ox.api.setModal(true);
                    showNode("config_popups_win");
                    $("config_popups_win").style.display="block";
                }
                
                showNode("window_external_module");
                centerPopupWindow($("window_external_module"));
                $("window_external_module").style.display="block";
                $("external_window_uwa_name").focus();
            },
            
            close : function(cancel) {
                if (!cancel && final_cb) {
                    var title = $("external_window_uwa_name").value;
                    var url =  $("external_window_uwa_uri").value;
                    if (trimStr(title).length == 0 || trimStr(url).length == 0) {
                        // invalid input
                        return;
                    }
                    
                    var parameters = ox.uwa.util.convertParameters($("external_window_uwa_params").value);
                    
                    final_cb({
                        id: $("external_window_uwa_id").value,
                        title: title,
                        autorefresh: $("external_autorefresh").checked,
                        url: url,
                        standalone: $("external_standalone").checked,
                        parameters: parameters || ""
                    });
                }
                // reset to default
                $("external_window_uwa_id").value = "";
                $("external_window_uwa_name").value = "";
                $("external_autorefresh").checked = false;
                $("external_window_uwa_uri").value = "";
                $("external_standalone").checked = false;
                $("external_window_uwa_params").value = "";
                delete(final_cb);
                
                if (this.closecb) { 
                    globalalert.cbclose(); 
                }
                hideNode("window_external_module");
                $("window_external_module").style.display="none";
                hideNode("config_popups_win");
                $("config_popups_win").style.display = "none";
                var childs = $("modal-dialog").childNodes;
                var closeall = true;
                for (var i=0; i < childs.length; i++) {
                    if (childs[i].tagName && childs[i].tagName == "DIV") {
                        if (childs[i].style.display && childs[i].style.display!= "none" ) {
                            closeall=false;
                        }
                    }
                }
                if (closeall) {
                    ox.api.setModal(false);
                }
            }
        };
    }()),
        
    storeUWA : function(uwa) {
        if (!uwa) return;
                
        // either edit or new!?
        if (uwa.id) {
            cnf_PE.grid.storage.localUpdate([uwa.id], function(index, object) {
                uwa.visible = object.visible || false;
                return uwa;
            });
            ox.uwa.update(uwa);
        } else {
            uwa.visible = true;
            ox.uwa.add(uwa);
            // append to grid
            cnf_PE.grid.storage.append([uwa]);
        }
        configuration_changed_fields["gui"] = true;
    },
    
    removeUWA : function() {
        var ids = cnf_PE.grid.selection.getSelected();
        if (ids && ids.length) {
            cnf_PE.grid.storage.removeIDs(ids);
            ox.uwa.remove(ids);
            configuration_changed_fields["gui"] = true;
        }
    },
        
    saveConfiguration : function() {
        if (ox.uwa.toStore && isEmpty(ox.uwa.toStore) === false) {
            // timing issue, view switch comes before the save
            // so we need to trigger a refresh first
            if ("oPortal" in window === true) {
                oPortal.refresh();
            }
            ox.uwa.save(function(data) {
                triggerEvent("OX_Configuration_Changed");
                configuration_changed_fields["gui"] = false;
                var errors = false;
                for (var i = 0; i < data.length; i++) {
                    if (data[i] && data[i].error) {
                        errors = true;
                        triggerEvent("OX_New_Error", 4, formatError(data[i]));
                    }
                }
                if (!errors) {
                    // take care that ids are in sync, specially when widgets have been added
                    cnf_PE.enableGrid();
                    triggerEvent("OX_New_Info", 4,
                                 _("Your settings have been saved"));
                }
            });
        }
    },
    
    cancelConfiguration : function() {
        // reset cache and temp storages
        ox.uwa.reset();
        configuration_changed_fields["gui"] = false;
    }
};

var cnf_PE = new ConfigPortalExternal();

registerView("configuration/portal/external",
        function () {

            showNode("config_external");
            $("config_external").style.display="block";
            
            // custom UWA allowed?
            var customUWA = ox.api.config.get("ui.portal.customUWA", true) === true;
            
            if (customUWA) {
                // set link
                $("config.external.description").innerHTML = format(
                    _(uwaLink.text), ["<a href=\"" + uwaLink.link.format() + "\" target=\"_blank\">", "</a>"]
                );
            } else {
                // remove node
                jQuery("#config\\.external\\.description").parent().remove();
            }

            // sections
            var sections = [];
            
            // save section
            sections.push(temporary.configuration.saveButton);
            
            // UWA section
            if (customUWA) {
                sections.push({
                    title: _("UWA Modules"),
                    id: "modules",
                    buttons: [{
                        title: _("Add"),
                        id: "add",
                        icons: ["img/menu/add_extview.gif",
                                "img/menu/add_extview.gif"],
                        event: "OX_Configuration_External_Portalview_Add"
                    }, {
                        title: _("Edit"),
                        id: "edit",
                        icons: ["img/menu/externalview_edit_n.gif",
                                "img/menu/externalview_edit_d.gif"],
                        event: "OX_Configuration_Edit_External",
                        selection: "portal-external",
                        requires: ["one"]
                    }, {
                        title: _("Remove"),
                        id: "remove",
                        icons: ["img/menu/remove_extview.gif",
                                "img/menu/remove_extview_d.gif"],
                        event: "OX_Configuration_External_Portalview_Remove",
                        selection: "portal-external",
                        requires: ["some"]
                    }]
                });
            }
            
            // visibility section
            sections.push({
                title: _("Visibility"),
                id: "visibility",
                buttons: [{
                    title: _("Enable"),
                    id: "enable",
                    icons: ["img/menu/externalview_activate_n.gif",
                            "img/menu/externalview_activate_d.gif"],
                    event: "OX_Configuration_Enable_External",
                    selection: "portal-external",
                    requires: ["some"]
                }, {
                    title: _("Disable"),
                    id: "disable",
                    icons: ["img/menu/externalview_deactivate_n.gif",
                            "img/menu/externalview_deactivate_d.gif"],
                    event: "OX_Configuration_Disable_External",
                    selection: "portal-external",
                    requires: ["some"]
                }]
            });
            
            // toolbar
            if (!configToolbars.UWAModules) {
                configToolbars.UWAModules = temporary.configuration.newToolbar(
                    _("UWA Modules"), sections, "portal-external"
                );
                ox.ToolBarController.processSelection("portal-external", false, []);
            }
            temporary.configuration.showToolbar(configToolbars.UWAModules);
        },
        function() { 
            setConfigPath($("cext_header"));
            register("OX_SAVE_OBJECT", cnf_PE.saveConfiguration);
            register("OX_Cancel_Object", cnf_PE.cancelConfiguration);
            register("OX_Configuration_External_Portalview_Add", cnf_PE.addUWA);
            register("OX_Configuration_Edit_External", cnf_PE.editUWA);
            register("OX_Configuration_External_Portalview_Remove", cnf_PE.removeUWA);
            register("OX_Configuration_Enable_External", cnf_PE.activate);
            register("OX_Configuration_Disable_External", cnf_PE.deactivate); 
            if (!cnf_PE.grid) {
                cnf_PE.initGrid();
            }
            cnf_PE.enableGrid();
        },
        function() {
            unregister("OX_SAVE_OBJECT", cnf_PE.saveConfiguration);
            unregister("OX_Cancel_Object", cnf_PE.cancelConfiguration);
            unregister("OX_Configuration_External_Portalview_Add", cnf_PE.addUWA);
            unregister("OX_Configuration_Edit_External", cnf_PE.editUWA);
            unregister("OX_Configuration_External_Portalview_Remove", cnf_PE.removeUWA);
            unregister("OX_Configuration_Enable_External", cnf_PE.activate);
            unregister("OX_Configuration_Disable_External", cnf_PE.deactivate); 
            cnf_PE.disableGrid();
        },
        function() { 
            hideNode("config_external"); 
            $("config_external").style.display="none"; 
        },
        function() { }
    );

register("Loaded", function () {
    addOnClose($("window_external_module"), function() { 
        cnf_PE.dialog.close(true);
    }); 
});