/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

registerView("configuration/tasks/preferences",
	function () { 
		showNode("config_tasks"); 
		$("config_tasks").style.display="block";
        
        // toolbar
        temporary.configuration.showToolbar(
            temporary.configuration.defaultToolbar);
	},
	function() {
	    register("OX_SAVE_OBJECT",ct_saveConfiguration);
		register("OX_Cancel_Object",ct_cancelConfiguration);
		ct_enter();
	},
	function() {
		//configuration_askforSave();
	    unregister("OX_SAVE_OBJECT",ct_saveConfiguration);
		unregister("OX_Cancel_Object",ct_cancelConfiguration);
		ct_leave();
	},
	function () { 
		hideNode("config_tasks"); 
		$("config_tasks").style.display="none"; },
	function() { ct_enter();}
);

var ct_init_bool=false;
var ct_default_level1;
var ct_interval;
register("OX_Configuration_Loaded",ct_onconfigload);
function ct_onconfigload() {
    addDefaultView("tasks/list", _("List view"));
    addDefaultView("tasks/split", _("H-split view"));
}
function ct_init() {
	ct_default_level1= new ComboBox3(window, "ct_default_level1", "16em", 1, true,"OX_Configuration_GUI_Changed", 5);
	var tasviews=getDefaultSubviews("tasks");
	for (var i in tasviews) {
		ct_default_level1.addElement(tasviews[i],i);
	}
	ct_default_level1.getDomNode();
	ct_interval = new ComboBox3(window, "ct_interval", "16em", 1, true,"OX_Configuration_GUI_Changed", null);
    ct_interval.addElement(noI18n("5"), 5);
    ct_interval.addElement(noI18n("10"), 10);
    ct_interval.addElement(noI18n("15"), 15);
    ct_interval.addElement(noI18n("20"), 20);
    ct_interval.addElement(noI18n("30"), 30);
    ct_interval.addElement(noI18n("60"), 60);
	ct_interval.getDomNode();

}
function ct_enter() {
	if(!ct_init_bool) {
		ct_init();
		ct_init_bool=true;
	}
	if(configContainsKey("gui.tasks.view")) {
		ct_default_level1.setKey(configGetKey("gui.tasks.view"));
		configuration_changed_fields["gui"]=false;
	}	
	if(configContainsKey("gui.tasks.interval")) {
		ct_interval.setKey(configGetKey("gui.tasks.interval"));
		configuration_changed_fields["gui"]=false;
	}	
	if(configContainsKey("gui.effects.hover.tasks")) {
		setIntofRadioBox("ct_enablehovertasks",configGetKey("gui.effects.hover.tasks"));
		configuration_changed_fields["gui"]=false;
	}
    if(configContainsKey("modules.tasks.notifyNewModifiedDeleted")) {
        setValueofRadioBox("cs_tasknotification_0",configGetKey("modules.tasks.notifyNewModifiedDeleted"));
        configuration_changed_fields["tasknotification"]=false;
    }
	if(configContainsKey("modules.tasks.notifyAcceptedDeclinedAsCreator")) {
        setValueofRadioBox("cs_tasknotification_1",configGetKey("modules.tasks.notifyAcceptedDeclinedAsCreator"));
        configuration_changed_fields["tasknotification"]=false;
    }
    if(configContainsKey("modules.tasks.notifyAcceptedDeclinedAsParticipant")) {
        setValueofRadioBox("cs_tasknotification_2",configGetKey("modules.tasks.notifyAcceptedDeclinedAsParticipant"));
        configuration_changed_fields["tasknotification"]=false;
    }
	setConfigPath($("ct_header"));		
		
}
function ct_saveConfiguration() {
	if(configuration_changed_fields["gui"]==true) {
		configSetKey("gui.tasks.view",ct_default_level1.getKey());
		configSetKey("gui.tasks.interval",ct_interval.getKey());
		menulastviews["tasks"]=ct_default_level1.getKey();
		configSetKey("gui.effects.hover.tasks",getBoolofInt(getValueofRadioBox("ct_enablehovertasks")));
	}
	/*
	 * store notification settings to config, if changed 
	 */
	if (configuration_changed_fields["tasknotification"]) {
		configSetKey("modules.tasks.notifyNewModifiedDeleted",getBoolofInt(getValueofRadioBox("cs_tasknotification_0")));	
		configSetKey("modules.tasks.notifyAcceptedDeclinedAsCreator",getBoolofInt(getValueofRadioBox("cs_tasknotification_1")));
		configSetKey("modules.tasks.notifyAcceptedDeclinedAsParticipant",getBoolofInt(getValueofRadioBox("cs_tasknotification_2")));
	}
	triggerEvent("OX_Save_Configuration",false,false);
}
function ct_cancelConfiguration() {
	configuration_changed_fields["gui"]=false;
	ct_enter();
}
function ct_leave() {
}
fileloaded();