/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.connectors.BaseConnector;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.connectors.responses.ArrayDataResponseMto;
import com.openexchange.mobile.api.facade.connectors.responses.mtos.AccountMto;
import com.openexchange.mobile.api.facade.utils.StringUtils;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

public class AccountsConnector extends BaseConnector<ArrayDataResponseMto> {

    public AccountsConnector(RequestConfiguration configuration, SessionData sessionData) {
        super(configuration, sessionData, "account", ArrayDataResponseMto.class);
    }

    @Override
    protected HttpUriRequest createRequest() {
        RequestBuilder builder = RequestBuilder.get(createUrl());
        addSessionData(builder);
        builder.addParameter("action", "all");
        builder.addParameter("columns", "1001,1002,1006,1007,1009,1010,1011,1012,1039,1042,1046,1037,1005");
        return builder.build();
    }

    public static List<AccountMto> map(Object[][] data) {
        List<AccountMto> accounts = new ArrayList<>(data.length);
        for (int index = 0; index < data.length; index++) {
            accounts.add(map(data[index]));
        }
        return accounts;
    }

    public static AccountMto map(Object[] data) {
        String id = Integer.toString((Integer) data[0]);
        String accountName = (String) data[2];
        String primaryAddress = (String) data[3];
        String trashFolderName = (String) data[4];
        String sentFolderName = (String) data[5];
        String draftsFolderName = (String) data[6];
        String spamFolderName = (String) data[7];
        List<String> aliases = getAliases(primaryAddress, (String) data[8]);
        String archiveFolderId = (String) data[9];
        String rootFolderId = (String) data[10];
        String personal = (String) data[11];
        String transportUrl = (String) data[12];
        return new AccountMto(id, accountName, primaryAddress, aliases, transportUrl, rootFolderId, trashFolderName, sentFolderName, draftsFolderName, spamFolderName, archiveFolderId, personal);
    }

    private static List<String> getAliases(String primaryAddress, String aliasesStr) {
        if (StringUtils.isEmpty(aliasesStr)) {
            return null;
        }
        String[] splittedAliases = aliasesStr.split(",");
        for (int index = 0; index < splittedAliases.length; index++) {
            splittedAliases[index] = splittedAliases[index].trim();
        }
        List<String> aliases = new ArrayList<>(Arrays.asList(splittedAliases));
        while (aliases.remove(primaryAddress)) {
            // Nothing to do.
        }
        return aliases.isEmpty() ? null : aliases;
    }

}
