%define use_systemd (0%{?rhel} && 0%{?rhel} >= 7) || (0%{?suse_version} && 0%{?suse_version} >=1210)
Name:          open-xchange-mobile-api-facade
BuildArch:     noarch
#!BuildIgnore: post-build-checks
%if 0%{?rhel_version} && 0%{?rhel_version} == 600
BuildRequires: java7-devel
%else
BuildRequires: java-devel >= 1.7.0
%endif
%if 0%{?rhel_version} && 0%{?rhel_version} >= 700
BuildRequires: ant
%else
BuildRequires: ant-nodeps
%endif
BuildRequires: open-xchange-admin >= 7.8.4-3
BuildRequires: open-xchange-grizzly >= 7.8.4-3
BuildRequires: open-xchange-rest >= 7.8.4-3
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
BuildRequires:    systemd-rpm-macros
%endif
Version:       1.0.3
%define        ox_release 1
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       GPL-2.0
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Source1:       open-xchange-mobile-api-facade.init
Source2:       open-xchange-mobile-api-facade.service
%define        dropin_dir /etc/systemd/system/open-xchange-mobile-api-facade.service.d
%define        dropin_example limits.conf
Summary:       The Open-Xchange API facade for mobile apps
AutoReqProv:   no
Requires:      open-xchange-admin >= 7.8.4-3
Requires:      open-xchange-grizzly >= 7.8.4-3
Requires:      open-xchange-rest >= 7.8.4-3
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
Requires(pre):    systemd
Requires(post):   systemd
Requires(preun):  systemd
Requires(postun): systemd
%endif

%description
Package contains the micro service for running the API facade for mobile apps.

Authors:
--------
    Open-Xchange

%prep

%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build
mkdir -p %{buildroot}/var/log/open-xchange/mobile-api-facade
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
%__install -D -m 444 %{SOURCE2} %{buildroot}/usr/lib/systemd/system/open-xchange-mobile-api-facade.service
%else
mkdir -p %{buildroot}/etc/init.d
install -m 755 %{SOURCE1} %{buildroot}/etc/init.d/open-xchange-mobile-api-facade
%endif

# On Redhat and SuSE start scripts are not automatically added to system start. This is wanted behavior and standard.

%post
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
%service_add_post open-xchange-mobile-api-facade.service
%endif
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700)
if [ ! -f %{dropin_dir}/%{dropin_example} ]
then
  install -D -m 644 %{_defaultdocdir}/%{name}-%{version}/%{dropin_example} %{dropin_dir}/%{dropin_example}
fi
%endif
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
if [ ! -f %{dropin_dir}/%{dropin_example} ]
then
  install -D -m 644 %{_defaultdocdir}/%{name}/%{dropin_example} %{dropin_dir}/%{dropin_example}
fi
%endif

# Trigger a service definition/config reload
%if %{use_systemd}
systemctl daemon-reload &> /dev/null || :
%endif

%preun
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
%service_del_preun open-xchange-mobile-api-facade.service
%endif

%postun
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
%service_del_postun open-xchange-mobile-api-facade.service
%endif

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/mobile-api-facade/bundles/
/opt/open-xchange/mobile-api-facade/bundles/*
%dir %attr(750, open-xchange, root) /opt/open-xchange/mobile-api-facade/osgi/
/opt/open-xchange/mobile-api-facade/osgi/config.ini.template
%dir /opt/open-xchange/mobile-api-facade/osgi/bundle.d/
/opt/open-xchange/mobile-api-facade/osgi/bundle.d/*
%dir /opt/open-xchange/mobile-api-facade/etc/
%config(noreplace) /opt/open-xchange/mobile-api-facade/etc/*
%dir /opt/open-xchange/mobile-api-facade/sbin/
/opt/open-xchange/mobile-api-facade/sbin/open-xchange-mobile-api-facade
%dir %attr(750, open-xchange, root) /var/log/open-xchange/mobile-api-facade
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
/usr/lib/systemd/system/open-xchange-mobile-api-facade.service
%else
/etc/init.d/open-xchange-mobile-api-facade
%endif

%if %{use_systemd}
%doc docs/%{dropin_example}
%endif

%changelog
* Mon Oct 23 2017 Michael Koch <michael.koch@open-xchange.com>
Prepare for 1.0.3-1 release
