/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.connectors.BaseConnector;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.connectors.responses.MailResponseMto;
import com.openexchange.mobile.api.facade.connectors.responses.mtos.MailMto;
import com.openexchange.mobile.api.facade.models.Mail;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

public class GetMailConnector extends BaseConnector<MailResponseMto> {

    private static final String CODE_HTML_TOO_LARGE = "HTM-0003";

    private final String folderId;

    private final String mailId;

    public GetMailConnector(RequestConfiguration configuration, SessionData sessionData, String folderId, String mailId) {
        super(configuration, sessionData, "mail", MailResponseMto.class);
        this.folderId = folderId;
        this.mailId = mailId;
    }

    @Override
    protected HttpUriRequest createRequest() {
        RequestBuilder builder = RequestBuilder.get(createUrl());
        addSessionData(builder);
        builder.addParameter("action", "get");
        builder.addParameter("folder", folderId);
        builder.addParameter("id", mailId);
        builder.addParameter("view", "html");
        builder.addParameter("unseen", "1");
        builder.addParameter("estimate_length", "true");
        builder.addParameter("timezone", "utc");
        builder.addParameter("no_nested_message", "true");
        return builder.build();
    }

    @Override
    protected boolean isError(MailResponseMto responseBody) {
        if (CODE_HTML_TOO_LARGE.equals(responseBody.getCode())) {
            return false;
        }
        return super.isError(responseBody);
    }

    public static Mail map(MailMto mailMto) {
        return Mail.createMail(mailMto);
    }

}
