/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import java.nio.charset.Charset;

import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.connectors.BaseConnector;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.connectors.responses.ThreadReferencesResponseMto;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

public class ThreadReferencesConnector extends BaseConnector<ThreadReferencesResponseMto> {

    private final String folderId;

    public ThreadReferencesConnector(RequestConfiguration configuration, SessionData sessionData, String folderId) {
        super(configuration, sessionData, "mail", ThreadReferencesResponseMto.class);
        this.folderId = folderId;
    }

    @Override
    protected HttpUriRequest createRequest() {
        String numMailsPerFolder = sessionData.getConfiguration().getNumMailsPerFolder();
        RequestBuilder builder = RequestBuilder.post(createUrl());
        builder.setCharset(Charset.forName("UTF-8"));
        addSessionData(builder);
        builder.addParameter("action", "thread_references");
        builder.addParameter("folder", folderId);
        builder.addParameter("sort", "610");
        builder.addParameter("order", "desc");
        builder.addParameter("columns", "102,600,601,610,611");
        builder.addParameter("timezone", "utc");
        builder.addParameter("size", numMailsPerFolder);
        return builder.build();
    }

}
