/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.configuration;

import java.net.URI;
import java.net.URISyntaxException;

import com.openexchange.config.ConfigurationService;
import com.openexchange.java.Strings;

import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@UtilityClass
public class GlobalConfiguration {

    public static final String MIDDLEWARE_BASE_URL = "com.openexchange.mobile.api.facade.MiddlewareBaseUrl";

    public static final String VERSION_CHECK_ENABLED = "com.openexchange.mobile.api.facade.versionCheckEnabled";

    public static URI middlewareBaseUrl;

    public static boolean versionCheckEnabled;

    static {
        try {
            middlewareBaseUrl = new URI("http://localhost:8009/ajax/");
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void initialize(ConfigurationService configurationService) {
        middlewareBaseUrl = getMiddlewareBaseUrl(configurationService);
        versionCheckEnabled = ConfigurationHelper.getBoolean(configurationService, VERSION_CHECK_ENABLED, true);
        validate();
    }

    private void validate() {
        if (middlewareBaseUrl == null) {
            log.error("property \"" + MIDDLEWARE_BASE_URL + "\" not set");
        } else if (Strings.isEmpty(middlewareBaseUrl.getHost())) {
            log.error("hostname cannot get extracted from property \"" + MIDDLEWARE_BASE_URL + "\"");
        }
    }

    private URI getMiddlewareBaseUrl(ConfigurationService configurationService) {
        try {
            String value = ConfigurationHelper.getStringOrNull(configurationService, MIDDLEWARE_BASE_URL);
            if (Strings.isEmpty(value)) {
                return null;
            }
            if (!value.endsWith("/")) {
                value += "/";
            }
            return new URI(value);
        } catch (Exception e) {
            return null;
        }
    }

}
