/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors;

import java.util.List;

import com.openexchange.mobile.api.facade.auth.LoginCredentials;
import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.auth.impl.LoginConnector;
import com.openexchange.mobile.api.facade.auth.impl.LogoutConnector;
import com.openexchange.mobile.api.facade.connectors.impl.AccountsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.AllCapabilitiesConnector;
import com.openexchange.mobile.api.facade.connectors.impl.AllFoldersConnector;
import com.openexchange.mobile.api.facade.connectors.impl.AutoconfigureAccountConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ClearFolderConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ConfigConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ContactsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.CreateAccountConnector;
import com.openexchange.mobile.api.facade.connectors.impl.CreateFolderConnector;
import com.openexchange.mobile.api.facade.connectors.impl.DeleteAccountConnector;
import com.openexchange.mobile.api.facade.connectors.impl.DeleteFolderConnector;
import com.openexchange.mobile.api.facade.connectors.impl.DeleteMailsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.EnvelopesConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ExamineMultipleFoldersConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ExpungeFolderConnector;
import com.openexchange.mobile.api.facade.connectors.impl.GetAccountConnector;
import com.openexchange.mobile.api.facade.connectors.impl.GetJsLobConnector;
import com.openexchange.mobile.api.facade.connectors.impl.GetMailConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ManifestsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.MoveMailsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.PnsSubscribeConnector;
import com.openexchange.mobile.api.facade.connectors.impl.PnsUnsubscribeConnector;
import com.openexchange.mobile.api.facade.connectors.impl.SetAndClearFlagsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.SetColorsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.StubsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ThreadReferencesConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ThreadedAllStubsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.UpdateAccountConnector;
import com.openexchange.mobile.api.facade.connectors.impl.UpdateFolderConnector;
import com.openexchange.mobile.api.facade.connectors.impl.UserConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ValidateAccountConnector;
import com.openexchange.mobile.api.facade.connectors.impl.VersionConnector;
import com.openexchange.mobile.api.facade.endpoints.requests.AutoconfigData;
import com.openexchange.mobile.api.facade.models.Folder;
import com.openexchange.mobile.api.facade.models.MailAccountData;
import com.openexchange.mobile.api.facade.models.MailFlags;

public interface ConnectorFactory {

    GetAccountConnector getAccountConnector(SessionData sessionData, String accountId);

    AccountsConnector getAccountsConnector(SessionData sessionData);

    AllCapabilitiesConnector getAllCapabilities(SessionData sessionData);

    AllFoldersConnector getAllFoldersConnector(SessionData sessionData, String rootFolderId, String language);

    ClearFolderConnector getClearFolderConnector(SessionData sessionData, String folderId);

    ConfigConnector getConfigConnector(SessionData sessionData);

    ContactsConnector getContactsConnector(SessionData sessionData);

    CreateFolderConnector getCreateFolderConnector(SessionData sessionData, String parentFolderId, String name);

    UpdateFolderConnector getUpdateFolderConnector(SessionData sessionData, String folderId, String newParentFolderId, String newName);

    DeleteAccountConnector getDeleteAccountConnector(SessionData sessionData, String accountId);

    DeleteFolderConnector getDeleteFolderConnector(SessionData sessionData, String folderId);

    DeleteMailsConnector getDeleteMailsConnector(SessionData sessionData, String folderId, List<String> mailIds, boolean purge);

    EnvelopesConnector getEnvelopesConnector(SessionData sessionData, String folderId, List<String> mailIds);

    ExamineMultipleFoldersConnector getExamineFolderConnector(SessionData sessionData, String folderId);

    ExamineMultipleFoldersConnector getExamineMultipleFoldersConnector(SessionData sessionData, List<Folder> folderIds);

    ExpungeFolderConnector getExpungeFolderConnector(SessionData sessionData, String folderId);

    GetJsLobConnector getGetJsLobConnector(SessionData sessionData, String name);

    GetMailConnector getGetMailConnector(SessionData sessionData, String folderId, String mailId);

    LoginConnector getLoginConnector(LoginCredentials credentials);

    LogoutConnector getLogoutConnector(SessionData sessionData);

    ManifestsConnector getManifestsConnector();

    CreateAccountConnector getCreateAccountConnector(SessionData sessionData, MailAccountData account);

    MoveMailsConnector getMoveMailsConnector(SessionData sessionData, String folderId, List<String> mailIds, String targetFolderId);

    PnsSubscribeConnector getPnsSubscribeConnector(SessionData sessionData, String transport, String token, List<String> tokens);

    PnsUnsubscribeConnector getPnsUnsubscribeConnector(SessionData sessionData, String transport, String token);

    SetAndClearFlagsConnector getSetAndClearFlagsConnector(SessionData sessionData, String folderId, List<String> mailIds, MailFlags flags, boolean value);

    SetColorsConnector getSetColorsConnector(SessionData sessionData, String folderId, List<String> mailIds, int color);

    StubsConnector getStubsConnector(SessionData sessionData, String folderId, boolean threaded);

    ThreadedAllStubsConnector getThreadedAllStubsConnector(SessionData sessionData, String folderId);

    ThreadReferencesConnector getThreadReferencesConnector(SessionData sessionData, String folderId);

    UpdateAccountConnector getUpdateAccountConnector(SessionData sessionData, MailAccountData account);

    UserConnector getUserConnector(SessionData sessionData);

    ValidateAccountConnector getValidateAccountConnector(SessionData sessionData, MailAccountData account, boolean forceInsecureConnection, boolean ignoreInvalidTransport);

    VersionConnector getVersionConnector();

    AutoconfigureAccountConnector getAutoconfigureAccountConnector(SessionData sessionData, AutoconfigData autoconfigData);

}
