/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.connectors.BaseConnector;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.connectors.responses.UserResponseMto;
import com.openexchange.mobile.api.facade.connectors.responses.mtos.UserMto;
import com.openexchange.mobile.api.facade.models.User;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

public class UserConnector extends BaseConnector<UserResponseMto> {

    public UserConnector(RequestConfiguration configuration, SessionData sessionData) {
        super(configuration, sessionData, "user", UserResponseMto.class);
    }

    @Override
    protected HttpUriRequest createRequest() {
        RequestBuilder builder = RequestBuilder.get(createUrl());
        addSessionData(builder);
        builder.addParameter("action", "get");
        builder.addParameter("columns", "1,500,501,502,524,601,606");
        return builder.build();
    }

    public static User map(UserResponseMto responseMto) {
        UserMto userMto = responseMto.getData();
        return new User(userMto.getFirstName(), userMto.getLastName(), userMto.getDisplayName(), userMto.getImage(), userMto.getImageType());
    }

}
