/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.endpoints;

import javax.annotation.security.PermitAll;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.openexchange.mobile.api.facade.configuration.ConfigurationHelper;
import com.openexchange.mobile.api.facade.endpoints.responses.ctos.ManifestCto;
import com.openexchange.mobile.api.facade.models.Manifest;
import com.openexchange.mobile.api.facade.services.ManifestService;
import com.openexchange.mobile.api.facade.utils.RequestUtil;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Path("/api-facade/v1/manifest")
@RequiredArgsConstructor
@PermitAll
@Slf4j
public class ManifestEndpoint {

    private final ManifestService manifestService;

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public Response getManifest(@Context HttpServletRequest request) {
        log.info("Retrieving manifest");
        ConfigurationHelper.getConfiguration(request);
        Manifest manifest = manifestService.getManifest();
        ManifestCto manifestCto = new ManifestCto(manifest);
        return RequestUtil.jsonResponse(manifestCto);
    }

}
