/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.data;

import com.openexchange.osgi.data.BundleImport;
import com.openexchange.osgi.data.JDK;
import com.openexchange.osgi.data.OSGIManifest;
import com.openexchange.osgi.data.RequiredBundle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class AbstractModule {
    protected File file;
    protected String name;
    protected OSGIManifest osgiManifest;
    private String fragmentHostName;
    protected AbstractModule fragmentHost;
    protected final Set<AbstractModule> dependencies = new HashSet<AbstractModule>();

    protected AbstractModule(File file) {
        this.file = file;
        this.name = file.getName();
    }

    public Set<String> getExportedPackages() {
        Set<String> retval = null == this.osgiManifest ? Collections.emptySet() : this.osgiManifest.getExports();
        return retval;
    }

    public void computeDependencies(Map<String, AbstractModule> modulesByName, Map<String, Set<AbstractModule>> modulesByPackage, Map<String, AbstractModule> modulesByFilename, boolean strict) throws Exception {
        if (this.osgiManifest != null) {
            for (BundleImport imported : this.osgiManifest.getImports()) {
                Set<AbstractModule> exportingModules = modulesByPackage.get(imported.getPackageName());
                if (exportingModules != null) {
                    for (AbstractModule module : exportingModules) {
                        if (module == this) continue;
                        this.dependencies.add(module);
                    }
                    continue;
                }
                if (JDK.exports(imported.getPackageName()) || imported.isOptional() || !strict) continue;
                throw new Exception("Can not find bundle that exports \"" + imported.getPackageName() + "\" to resolve import of bundle \"" + this.name + "\".");
            }
            for (RequiredBundle requiredBundle : this.osgiManifest.getRequiredBundles()) {
                AbstractModule requiredModule = modulesByName.get(requiredBundle.getPackageName());
                if (null == requiredModule) {
                    if (!strict) continue;
                    throw new Exception("Can not find bundle to resolve require bundle \"" + requiredBundle.getPackageName() + "\".");
                }
                if (!this.equals(requiredModule)) {
                    this.dependencies.add(requiredModule);
                    continue;
                }
                throw new Exception(this.name + " requires bundle " + requiredBundle.getPackageName());
            }
            this.fragmentHostName = this.osgiManifest.getEntry("Fragment-Host");
            if (this.fragmentHostName != null && !"system.bundle".equals(this.fragmentHostName)) {
                this.fragmentHost = modulesByName.get(this.fragmentHostName);
                if (null == this.fragmentHost) {
                    if (strict) {
                        throw new Exception("Can not find bundle for fragment host \"" + this.fragmentHostName + "\".");
                    }
                } else {
                    this.dependencies.add(this.fragmentHost);
                    this.dependencies.addAll(this.fragmentHost.getDependencies(false));
                    if (this.dependencies.contains(this)) {
                        throw new Exception("Fragment Host " + this.fragmentHost.getName() + " requires fragment " + this.name);
                    }
                }
            }
        }
    }

    public List<AbstractModule> getDependencies(boolean transitive) {
        ArrayList<AbstractModule> retval = new ArrayList<AbstractModule>();
        if (transitive) {
            AbstractModule.getDependenciesTransitively(retval, this);
        } else {
            retval.addAll(this.dependencies);
        }
        return retval;
    }

    private static void getDependenciesTransitively(List<AbstractModule> retval, AbstractModule module) {
        boolean addedOne = false;
        for (AbstractModule dependency : module.getDependencies(false)) {
            if (retval.contains(dependency)) continue;
            retval.add(dependency);
            addedOne = true;
        }
        if (!addedOne) {
            return;
        }
        for (AbstractModule dependency : module.getDependencies(false)) {
            AbstractModule.getDependenciesTransitively(retval, dependency);
        }
    }

    public List<String> getRequiredClasspath() {
        return this.getRequiredClasspath(false);
    }

    public List<String> getRequiredClasspath(boolean transitive) {
        ArrayList<String> retval = new ArrayList<String>();
        for (AbstractModule dependency : this.getDependencies(transitive)) {
            retval.addAll(dependency.getExportedClasspath());
        }
        return Collections.unmodifiableList(retval);
    }

    public List<String> getFullRuntimeClasspath() {
        ArrayList<String> retval = new ArrayList<String>();
        for (AbstractModule dependency : this.getDependencies(true)) {
            retval.addAll(dependency.getExportedClasspath());
            retval.addAll(dependency.getRuntimeClasspath());
        }
        return Collections.unmodifiableList(retval);
    }

    public boolean isFragment() {
        if (this.osgiManifest != null) {
            this.fragmentHostName = this.osgiManifest.getEntry("Fragment-Host");
        }
        return null != this.fragmentHostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isExported(File classpathEntry) throws IOException {
        if (!classpathEntry.exists() || classpathEntry.isDirectory()) {
            return false;
        }
        JarFile jarFile = new JarFile(classpathEntry);
        try {
            for (String exportedPackage : this.getExportedPackages()) {
                String expected = exportedPackage.replace('.', '/') + '/';
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(expected)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            jarFile.close();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        AbstractModule other = (AbstractModule)o;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    protected abstract Set<String> getExportedClasspath();

    protected abstract Set<String> getRuntimeClasspath();

    public Set<String> getSourceDirs() {
        return Collections.emptySet();
    }

    public Set<String> getTestSourceDirs() {
        return Collections.emptySet();
    }

    public File getFile() {
        return this.file;
    }

    protected static Set<String> addBundlePath(File bundleDir, Set<String> classpath) {
        HashSet<String> retval = new HashSet<String>();
        for (String classpathEntry : classpath) {
            retval.add(new File(bundleDir, classpathEntry).getAbsolutePath());
        }
        return retval;
    }
}

