/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache.subscriber;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.querycache.subscriber.ListenerInfo;
import com.hazelcast.client.impl.querycache.subscriber.QueryCacheToListenerMapper;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.impl.listener.AbstractClientListenerService;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.EventLostEvent;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.event.EventData;
import com.hazelcast.map.impl.querycache.ListenerRegistrationHelper;
import com.hazelcast.map.impl.querycache.QueryCacheEventService;
import com.hazelcast.map.impl.querycache.event.BatchEventData;
import com.hazelcast.map.impl.querycache.event.BatchIMapEvent;
import com.hazelcast.map.impl.querycache.event.LocalEntryEventData;
import com.hazelcast.map.impl.querycache.event.QueryCacheEventData;
import com.hazelcast.map.impl.querycache.event.SingleIMapEvent;
import com.hazelcast.map.impl.querycache.subscriber.EventPublisherHelper;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheEventListenerAdapters;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.impl.eventservice.impl.TrueEventFilter;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.executor.StripedExecutor;
import com.hazelcast.util.executor.StripedRunnable;
import com.hazelcast.util.executor.TimeoutRunnable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class ClientQueryCacheEventService
implements QueryCacheEventService {
    private static final int EVENT_QUEUE_TIMEOUT_MILLIS = 500;
    private static final ConstructorFunction<String, QueryCacheToListenerMapper> REGISTRY_CONSTRUCTOR = new ConstructorFunction<String, QueryCacheToListenerMapper>(){

        @Override
        public QueryCacheToListenerMapper createNew(String arg) {
            return new QueryCacheToListenerMapper();
        }
    };
    private final ILogger logger = Logger.getLogger(this.getClass());
    private final StripedExecutor executor;
    private final ConcurrentMap<String, QueryCacheToListenerMapper> registrations;
    private final SerializationService serializationService;
    private final ClientListenerService listenerService;

    public ClientQueryCacheEventService(ClientContext clientContext) {
        AbstractClientListenerService listenerService = (AbstractClientListenerService)clientContext.getListenerService();
        this.listenerService = listenerService;
        this.serializationService = clientContext.getSerializationService();
        this.executor = listenerService.getEventExecutor();
        this.registrations = new ConcurrentHashMap<String, QueryCacheToListenerMapper>();
    }

    @Override
    public boolean hasListener(String mapName, String cacheId) {
        QueryCacheToListenerMapper queryCacheToListenerMapper = (QueryCacheToListenerMapper)this.registrations.get(mapName);
        if (queryCacheToListenerMapper == null) {
            return false;
        }
        return queryCacheToListenerMapper.hasListener(cacheId);
    }

    public ConcurrentMap<String, QueryCacheToListenerMapper> getRegistrations() {
        return this.registrations;
    }

    @Override
    public void sendEventToSubscriber(String name, Object eventData, int orderKey) {
        throw new UnsupportedOperationException();
    }

    public void publish(String mapName, String cacheId, Object event, int orderKey) {
        Preconditions.checkHasText(mapName, "mapName");
        Preconditions.checkHasText(cacheId, "cacheId");
        Preconditions.checkNotNull(event, "event cannot be null");
        Collection<ListenerInfo> listeners = this.getListeners(mapName, cacheId);
        for (ListenerInfo info : listeners) {
            try {
                this.executor.execute(new EventDispatcher(event, info, orderKey, this.serializationService, 500L));
            }
            catch (RejectedExecutionException e) {
                this.logger.warning("EventQueue overloaded! Can not process IMap=[" + mapName + "], QueryCache=[ " + cacheId + "], Event=[" + event + "]");
            }
        }
    }

    @Override
    public String addPublisherListener(String mapName, String cacheId, ListenerAdapter adapter) {
        String listenerName = ListenerRegistrationHelper.generateListenerName(mapName, cacheId);
        QueryCacheHandler handler = new QueryCacheHandler(adapter);
        return this.listenerService.registerListener(this.createPublisherListenerCodec(listenerName), handler);
    }

    @Override
    public boolean removePublisherListener(String mapName, String cacheId, String listenerId) {
        return this.listenerService.deregisterListener(listenerId);
    }

    private ListenerMessageCodec createPublisherListenerCodec(final String listenerName) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ContinuousQueryAddListenerCodec.encodeRequest(listenerName, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return ContinuousQueryAddListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest(listenerName, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public String addListener(String mapName, String cacheId, MapListener listener) {
        return this.addListener(mapName, cacheId, listener, null);
    }

    @Override
    public String addListener(String mapName, String cacheId, MapListener listener, EventFilter filter) {
        Preconditions.checkHasText(mapName, "mapName");
        Preconditions.checkHasText(cacheId, "cacheId");
        Preconditions.checkNotNull(listener, "listener cannot be null");
        QueryCacheToListenerMapper queryCacheToListenerMapper = ConcurrencyUtil.getOrPutIfAbsent(this.registrations, mapName, REGISTRY_CONSTRUCTOR);
        ListenerAdapter listenerAdaptor = QueryCacheEventListenerAdapters.createQueryCacheListenerAdaptor(listener);
        return queryCacheToListenerMapper.addListener(cacheId, listenerAdaptor, filter);
    }

    @Override
    public boolean removeListener(String mapName, String cacheId, String listenerId) {
        Preconditions.checkHasText(mapName, "mapName");
        Preconditions.checkHasText(cacheId, "cacheId");
        Preconditions.checkHasText(listenerId, "listenerId");
        QueryCacheToListenerMapper queryCacheToListenerMapper = ConcurrencyUtil.getOrPutIfAbsent(this.registrations, mapName, REGISTRY_CONSTRUCTOR);
        return queryCacheToListenerMapper.removeListener(cacheId, listenerId);
    }

    @Override
    public void removeAllListeners(String mapName, String cacheId) {
        Preconditions.checkHasText(mapName, "mapName");
        Preconditions.checkHasText(cacheId, "cacheId");
        QueryCacheToListenerMapper queryCacheToListenerMap = (QueryCacheToListenerMapper)this.registrations.get(mapName);
        if (queryCacheToListenerMap != null) {
            queryCacheToListenerMap.removeAllListeners(cacheId);
        }
    }

    private Collection<ListenerInfo> getListeners(String mapName, String cacheName) {
        QueryCacheToListenerMapper queryCacheToListenerMapper = (QueryCacheToListenerMapper)this.registrations.get(mapName);
        if (queryCacheToListenerMapper == null) {
            return Collections.emptySet();
        }
        return queryCacheToListenerMapper.getListenerInfos(cacheName);
    }

    private static class EventDispatcher
    implements StripedRunnable,
    TimeoutRunnable {
        private final Object event;
        private final ListenerInfo listenerInfo;
        private final int orderKey;
        private final long timeoutMs;
        private final SerializationService serializationService;

        public EventDispatcher(Object event, ListenerInfo listenerInfo, int orderKey, SerializationService serializationService, long timeoutMs) {
            this.event = event;
            this.listenerInfo = listenerInfo;
            this.orderKey = orderKey;
            this.timeoutMs = timeoutMs;
            this.serializationService = serializationService;
        }

        @Override
        public int getKey() {
            return this.orderKey;
        }

        @Override
        public void run() {
            LocalEntryEventData localEntryEventData;
            EventData eventData = (EventData)this.event;
            EventFilter filter = this.listenerInfo.getFilter();
            if (eventData instanceof LocalEntryEventData && eventData.getEventType() != EventLostEvent.EVENT_TYPE && !this.canPassFilter(localEntryEventData = (LocalEntryEventData)eventData, filter)) {
                return;
            }
            IMapEvent event = EventPublisherHelper.createIMapEvent(eventData, filter, null, this.serializationService);
            ListenerAdapter listenerAdapter = this.listenerInfo.getListenerAdapter();
            listenerAdapter.onEvent(event);
        }

        private boolean canPassFilter(LocalEntryEventData eventData, EventFilter filter) {
            if (filter == null || filter instanceof TrueEventFilter) {
                return true;
            }
            Object value = this.getValueOrOldValue(eventData);
            Data keyData = eventData.getKeyData();
            QueryEntry entry = new QueryEntry((InternalSerializationService)this.serializationService, keyData, value, Extractors.empty());
            return filter.eval(entry);
        }

        private Object getValueOrOldValue(LocalEntryEventData localEntryEventData) {
            Object value = localEntryEventData.getValue();
            return value != null ? value : localEntryEventData.getOldValue();
        }

        @Override
        public long getTimeout() {
            return this.timeoutMs;
        }

        @Override
        public TimeUnit getTimeUnit() {
            return TimeUnit.MILLISECONDS;
        }
    }

    private final class QueryCacheHandler
    extends ContinuousQueryAddListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final ListenerAdapter adapter;

        private QueryCacheHandler(ListenerAdapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }

        @Override
        public void handle(QueryCacheEventData data) {
            this.adapter.onEvent(new SingleIMapEvent(data));
        }

        @Override
        public void handle(Collection<QueryCacheEventData> events, String source, int partitionId) {
            this.adapter.onEvent(new BatchIMapEvent(new BatchEventData(events, source, partitionId)));
        }
    }
}

