/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.Offloadable;
import com.hazelcast.core.ReadOnly;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.operation.EntryBackupOperation;
import com.hazelcast.map.impl.operation.EntryOffloadableLockMismatchException;
import com.hazelcast.map.impl.operation.EntryOffloadableSetUnlockOperation;
import com.hazelcast.map.impl.operation.EntryOperator;
import com.hazelcast.map.impl.operation.KeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.BlockingOperation;
import com.hazelcast.spi.CallStatus;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class EntryOperation
extends KeyBasedMapOperation
implements BackupAwareOperation,
BlockingOperation,
MutatingOperation {
    private static final int SET_UNLOCK_FAST_RETRY_LIMIT = 10;
    private EntryProcessor entryProcessor;
    private transient boolean offloading;
    private transient Object response;
    private transient boolean readOnly;
    private transient int setUnlockRetryCount;
    private transient long begin;
    private transient OperationServiceImpl ops;
    private transient ExecutionService exs;

    public EntryOperation() {
    }

    public EntryOperation(String name, Data dataKey, EntryProcessor entryProcessor) {
        super(name, dataKey);
        this.entryProcessor = entryProcessor;
    }

    @Override
    public void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        this.ops = (OperationServiceImpl)this.getNodeEngine().getOperationService();
        this.exs = this.getNodeEngine().getExecutionService();
        this.begin = Clock.currentTimeMillis();
        this.readOnly = this.entryProcessor instanceof ReadOnly;
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        ManagedContext managedContext = serializationService.getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    @Override
    public CallStatus call() {
        if (this.shouldWait()) {
            return CallStatus.WAIT;
        }
        if (this.offloading) {
            this.runOffloaded();
            return CallStatus.OFFLOADED;
        }
        this.runVanilla();
        return CallStatus.DONE_RESPONSE;
    }

    public void runOffloaded() {
        if (!(this.entryProcessor instanceof Offloadable)) {
            throw new HazelcastException("EntryProcessor is expected to implement Offloadable for this operation");
        }
        if (this.readOnly && this.entryProcessor.getBackupProcessor() != null) {
            throw new HazelcastException("EntryProcessor.getBackupProcessor() should return null if ReadOnly implemented");
        }
        boolean shouldCloneForOffloading = InMemoryFormat.OBJECT.equals((Object)this.mapContainer.getMapConfig().getInMemoryFormat());
        Object oldValue = this.recordStore.get(this.dataKey, false);
        Object clonedOldValue = shouldCloneForOffloading ? this.toData(oldValue) : oldValue;
        String executorName = ((Offloadable)((Object)this.entryProcessor)).getExecutorName();
        String string = executorName = executorName.equals("hz:offloadable") ? "hz:offloadable" : executorName;
        if (this.readOnly) {
            this.runOffloadedReadOnlyEntryProcessor(clonedOldValue, executorName);
        } else {
            this.runOffloadedModifyingEntryProcessor(clonedOldValue, executorName);
        }
    }

    private void runOffloadedReadOnlyEntryProcessor(final Object oldValue, String executorName) {
        this.ops.onStartAsyncOperation(this);
        this.getNodeEngine().getExecutionService().execute(executorName, new Runnable(){

            @Override
            public void run() {
                try {
                    Data result = EntryOperator.operator(EntryOperation.this, EntryOperation.this.entryProcessor).operateOnKeyValue(EntryOperation.this.dataKey, oldValue).getResult();
                    EntryOperation.this.getOperationResponseHandler().sendResponse(EntryOperation.this, result);
                }
                catch (Throwable t) {
                    EntryOperation.this.getOperationResponseHandler().sendResponse(EntryOperation.this, t);
                }
                finally {
                    EntryOperation.this.ops.onCompletionAsyncOperation(EntryOperation.this);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOffloadedModifyingEntryProcessor(final Object oldValue, String executorName) {
        OperationServiceImpl ops = (OperationServiceImpl)this.getNodeEngine().getOperationService();
        final String finalCaller = UuidUtil.newUnsecureUuidString();
        Data finalDataKey = this.dataKey;
        final long finalThreadId = this.threadId;
        long finalCallId = this.getCallId();
        final long finalBegin = this.begin;
        this.lock(finalDataKey, finalCaller, finalThreadId, finalCallId);
        try {
            ops.onStartAsyncOperation(this);
            this.getNodeEngine().getExecutionService().execute(executorName, new Runnable(){

                @Override
                public void run() {
                    try {
                        EntryOperator entryOperator = EntryOperator.operator(EntryOperation.this, EntryOperation.this.entryProcessor).operateOnKeyValue(EntryOperation.this.dataKey, oldValue);
                        Data result = entryOperator.getResult();
                        EntryEventType modificationType = entryOperator.getEventType();
                        if (modificationType != null) {
                            Data newValue = EntryOperation.this.toData(entryOperator.getNewValue());
                            EntryOperation.this.updateAndUnlock(EntryOperation.this.toData(oldValue), newValue, modificationType, finalCaller, finalThreadId, result, finalBegin);
                        } else {
                            EntryOperation.this.unlockOnly(result, finalCaller, finalThreadId, finalBegin);
                        }
                    }
                    catch (Throwable t) {
                        EntryOperation.this.getLogger().severe("Unexpected error on Offloadable execution", t);
                        EntryOperation.this.unlockOnly(t, finalCaller, finalThreadId, finalBegin);
                    }
                }
            });
        }
        catch (Throwable t) {
            try {
                this.unlock(finalDataKey, finalCaller, finalThreadId, finalCallId, t);
                ExceptionUtil.sneakyThrow(t);
            }
            finally {
                ops.onCompletionAsyncOperation(this);
            }
        }
    }

    private Data toData(Object obj) {
        return this.mapServiceContext.toData(obj);
    }

    private void lock(Data finalDataKey, String finalCaller, long finalThreadId, long finalCallId) {
        boolean locked = this.recordStore.localLock(finalDataKey, finalCaller, finalThreadId, finalCallId, -1L);
        if (!locked) {
            throw new IllegalStateException(String.format("Could not obtain a lock by the caller=%s and threadId=%d", finalCaller, this.threadId));
        }
    }

    private void unlock(Data finalDataKey, String finalCaller, long finalThreadId, long finalCallId, Throwable cause) {
        boolean unlocked = this.recordStore.unlock(finalDataKey, finalCaller, finalThreadId, finalCallId);
        if (!unlocked) {
            throw new IllegalStateException(String.format("Could not unlock by the caller=%s and threadId=%d", finalCaller, this.threadId), cause);
        }
    }

    private void updateAndUnlock(Data previousValue, Data newValue, EntryEventType modificationType, String caller, long threadId, final Object result, long now) {
        EntryOffloadableSetUnlockOperation updateOperation = new EntryOffloadableSetUnlockOperation(this.name, modificationType, this.dataKey, previousValue, newValue, caller, threadId, now, this.entryProcessor.getBackupProcessor());
        updateOperation.setPartitionId(this.getPartitionId());
        updateOperation.setReplicaIndex(0);
        updateOperation.setNodeEngine(this.getNodeEngine());
        updateOperation.setCallerUuid(this.getCallerUuid());
        OperationAccessor.setCallerAddress(updateOperation, this.getCallerAddress());
        OperationResponseHandler setUnlockResponseHandler = new OperationResponseHandler(){

            public void sendResponse(Operation op, Object response) {
                if (EntryOperation.this.isRetryable(response) || EntryOperation.this.isTimeout(response)) {
                    this.retry(op);
                } else {
                    this.handleResponse(response);
                }
            }

            private void retry(final Operation op) {
                EntryOperation.this.setUnlockRetryCount++;
                if (EntryOperation.this.isFastRetryLimitReached()) {
                    EntryOperation.this.exs.schedule(new Runnable(){

                        @Override
                        public void run() {
                            EntryOperation.this.ops.execute(op);
                        }
                    }, 500L, TimeUnit.MILLISECONDS);
                } else {
                    EntryOperation.this.ops.execute(op);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void handleResponse(Object response) {
                if (response instanceof Throwable) {
                    Throwable t = (Throwable)response;
                    try {
                        if (t instanceof EntryOffloadableLockMismatchException) {
                            t = new RetryableHazelcastException(t.getMessage(), t);
                        }
                        EntryOperation.this.getOperationResponseHandler().sendResponse(EntryOperation.this, t);
                    }
                    finally {
                        EntryOperation.this.ops.onCompletionAsyncOperation(EntryOperation.this);
                    }
                }
                try {
                    EntryOperation.this.getOperationResponseHandler().sendResponse(EntryOperation.this, result);
                }
                finally {
                    EntryOperation.this.ops.onCompletionAsyncOperation(EntryOperation.this);
                }
            }
        };
        updateOperation.setOperationResponseHandler(setUnlockResponseHandler);
        this.ops.execute(updateOperation);
    }

    private boolean isRetryable(Object response) {
        return response instanceof RetryableHazelcastException && !(response instanceof WrongTargetException);
    }

    private boolean isTimeout(Object response) {
        return response instanceof CallTimeoutResponse;
    }

    private boolean isFastRetryLimitReached() {
        return this.setUnlockRetryCount > 10;
    }

    private void unlockOnly(Object result, String caller, long threadId, long now) {
        this.updateAndUnlock(null, null, null, caller, threadId, result, now);
    }

    private void runVanilla() {
        this.response = EntryOperator.operator(this, this.entryProcessor).operateOnKey(this.dataKey).doPostOperateOps().getResult();
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(this.getServiceNamespace(), this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        if (this.entryProcessor instanceof ReadOnly) {
            this.offloading = this.isOffloadingRequested(this.entryProcessor);
            return false;
        }
        if (!this.recordStore.isLocked(this.dataKey) && this.isOffloadingRequested(this.entryProcessor)) {
            this.offloading = true;
            return false;
        }
        this.offloading = false;
        return !this.recordStore.canAcquireLock(this.dataKey, this.getCallerUuid(), this.getThreadId());
    }

    private boolean isOffloadingRequested(EntryProcessor entryProcessor) {
        String executorName;
        return entryProcessor instanceof Offloadable && !(executorName = ((Offloadable)((Object)entryProcessor)).getExecutorName()).equals("no-offloading");
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(null);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new EntryBackupOperation(this.name, this.dataKey, backupProcessor) : null;
    }

    @Override
    public boolean shouldBackup() {
        return this.mapContainer.getTotalBackupCount() > 0 && this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Override
    public int getId() {
        return 20;
    }
}

