/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.drive;

/**
 * {@link DefaultDirectoryVersion}
 *
 * @author <a href="mailto:tobias.friedrich@open-xchange.com">Tobias Friedrich</a>
 * @since 7.10.3
 */
public class DefaultDirectoryVersion implements DirectoryVersion {

    private final String path;
    private final String checksum;

    /**
     * Initializes a new {@link DefaultDirectoryVersion}.
     *
     * @param path The path
     * @param checksum The checksum
     */
    public DefaultDirectoryVersion(String path, String checksum) {
        super();
        this.path = path;
        this.checksum = checksum;
    }

    @Override
    public String getChecksum() {
        return checksum;
    }

    @Override
    public String getPath() {
        return path;
    }

    @Override
    public String toString() {
        return getPath() + " | " + getChecksum();
    }

}
