/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.DeserializedGenericRecordCloner;
import com.hazelcast.internal.serialization.impl.compact.DeserializedSchemaBoundGenericRecordBuilder;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeserializedGenericRecord
extends CompactGenericRecord {
    private final TreeMap<String, Object> objects;
    private final Schema schema;

    public DeserializedGenericRecord(Schema schema, TreeMap<String, Object> objects) {
        this.schema = schema;
        this.objects = objects;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder newBuilder() {
        return new DeserializedSchemaBoundGenericRecordBuilder(this.schema);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder cloneWithBuilder() {
        return new DeserializedGenericRecordCloner(this.schema, this.objects);
    }

    @Override
    @Nonnull
    public FieldType getFieldType(@Nonnull String fieldName) {
        return this.schema.getField(fieldName).getType();
    }

    @Override
    public boolean hasField(@Nonnull String fieldName) {
        return this.objects.containsKey(fieldName);
    }

    @Override
    @Nonnull
    public Set<String> getFieldNames() {
        return this.objects.keySet();
    }

    @Override
    public boolean getBoolean(@Nonnull String fieldName) {
        return (Boolean)this.get(fieldName, FieldType.BOOLEAN);
    }

    @Override
    public byte getByte(@Nonnull String fieldName) {
        return (Byte)this.get(fieldName, FieldType.BYTE);
    }

    @Override
    public char getChar(@Nonnull String fieldName) {
        return ((Character)this.get(fieldName, FieldType.CHAR)).charValue();
    }

    @Override
    public double getDouble(@Nonnull String fieldName) {
        return (Double)this.get(fieldName, FieldType.DOUBLE);
    }

    @Override
    public float getFloat(@Nonnull String fieldName) {
        return ((Float)this.get(fieldName, FieldType.FLOAT)).floatValue();
    }

    @Override
    public int getInt(@Nonnull String fieldName) {
        return (Integer)this.get(fieldName, FieldType.INT);
    }

    @Override
    public long getLong(@Nonnull String fieldName) {
        return (Long)this.get(fieldName, FieldType.LONG);
    }

    @Override
    public short getShort(@Nonnull String fieldName) {
        return (Short)this.get(fieldName, FieldType.SHORT);
    }

    @Override
    @Nullable
    public String getString(@Nonnull String fieldName) {
        return (String)this.get(fieldName, FieldType.UTF);
    }

    @Override
    @Nullable
    public BigDecimal getDecimal(@Nonnull String fieldName) {
        return (BigDecimal)this.get(fieldName, FieldType.DECIMAL);
    }

    @Override
    @Nullable
    public LocalTime getTime(@Nonnull String fieldName) {
        return (LocalTime)this.get(fieldName, FieldType.TIME);
    }

    @Override
    @Nullable
    public LocalDate getDate(@Nonnull String fieldName) {
        return (LocalDate)this.get(fieldName, FieldType.DATE);
    }

    @Override
    @Nullable
    public LocalDateTime getTimestamp(@Nonnull String fieldName) {
        return (LocalDateTime)this.get(fieldName, FieldType.TIMESTAMP);
    }

    @Override
    @Nullable
    public OffsetDateTime getTimestampWithTimezone(@Nonnull String fieldName) {
        return (OffsetDateTime)this.get(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE);
    }

    @Override
    @Nullable
    public GenericRecord getGenericRecord(@Nonnull String fieldName) {
        return (GenericRecord)this.get(fieldName, FieldType.COMPOSED);
    }

    @Override
    @Nullable
    public boolean[] getBooleanArray(@Nonnull String fieldName) {
        return (boolean[])this.get(fieldName, FieldType.BOOLEAN_ARRAY);
    }

    @Override
    public byte[] getByteArray(@Nonnull String fieldName) {
        return (byte[])this.get(fieldName, FieldType.BYTE_ARRAY);
    }

    @Override
    public char[] getCharArray(@Nonnull String fieldName) {
        return (char[])this.get(fieldName, FieldType.CHAR_ARRAY);
    }

    @Override
    public double[] getDoubleArray(@Nonnull String fieldName) {
        return (double[])this.get(fieldName, FieldType.DOUBLE_ARRAY);
    }

    @Override
    public float[] getFloatArray(@Nonnull String fieldName) {
        return (float[])this.get(fieldName, FieldType.FLOAT_ARRAY);
    }

    @Override
    public int[] getIntArray(@Nonnull String fieldName) {
        return (int[])this.get(fieldName, FieldType.INT_ARRAY);
    }

    @Override
    public long[] getLongArray(@Nonnull String fieldName) {
        return (long[])this.get(fieldName, FieldType.LONG_ARRAY);
    }

    @Override
    public short[] getShortArray(@Nonnull String fieldName) {
        return (short[])this.get(fieldName, FieldType.SHORT_ARRAY);
    }

    @Override
    public String[] getStringArray(@Nonnull String fieldName) {
        return (String[])this.get(fieldName, FieldType.UTF_ARRAY);
    }

    @Override
    public BigDecimal[] getDecimalArray(@Nonnull String fieldName) {
        return (BigDecimal[])this.get(fieldName, FieldType.DECIMAL_ARRAY);
    }

    @Override
    public LocalTime[] getTimeArray(@Nonnull String fieldName) {
        return (LocalTime[])this.get(fieldName, FieldType.TIME_ARRAY);
    }

    @Override
    public LocalDate[] getDateArray(@Nonnull String fieldName) {
        return (LocalDate[])this.get(fieldName, FieldType.DATE_ARRAY);
    }

    @Override
    public LocalDateTime[] getTimestampArray(@Nonnull String fieldName) {
        return (LocalDateTime[])this.get(fieldName, FieldType.TIMESTAMP_ARRAY);
    }

    @Override
    public OffsetDateTime[] getTimestampWithTimezoneArray(@Nonnull String fieldName) {
        return (OffsetDateTime[])this.get(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY);
    }

    @Override
    @Nullable
    public GenericRecord[] getGenericRecordArray(@Nonnull String fieldName) {
        return (GenericRecord[])this.get(fieldName, FieldType.COMPOSED_ARRAY);
    }

    private <T> T get(@Nonnull String fieldName, FieldType fieldType) {
        this.check(fieldName, fieldType);
        return (T)this.objects.get(fieldName);
    }

    private void check(@Nonnull String fieldName, FieldType fieldType) {
        FieldDescriptor fd = this.schema.getField(fieldName);
        if (fd == null) {
            throw new HazelcastSerializationException("Invalid field name: '" + fieldName + " for " + this.schema);
        }
        if (!fd.getType().equals((Object)fieldType)) {
            throw new HazelcastSerializationException("Invalid field type: '" + fieldName + " for " + this.schema + ", expected : " + (Object)((Object)fd.getType()) + ", given : " + (Object)((Object)fieldType));
        }
    }

    @Override
    protected Object getClassIdentifier() {
        return this.schema.getTypeName();
    }
}

