/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.tcp.MemberProtocolEncoder;
import com.hazelcast.internal.server.tcp.ProtocolException;
import com.hazelcast.internal.server.tcp.SingleProtocolEncoder;
import com.hazelcast.internal.server.tcp.TcpServerConnection;
import com.hazelcast.internal.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;

public class SingleProtocolDecoder
extends InboundHandler<ByteBuffer, Void> {
    protected final InboundHandler[] inboundHandlers;
    protected final ProtocolType supportedProtocol;
    private final SingleProtocolEncoder encoder;
    private final boolean shouldSignalMemberProtocolEncoder;

    public SingleProtocolDecoder(ProtocolType supportedProtocol, InboundHandler next, SingleProtocolEncoder encoder) {
        this(supportedProtocol, new InboundHandler[]{next}, encoder, false);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public SingleProtocolDecoder(ProtocolType supportedProtocol, InboundHandler[] next, SingleProtocolEncoder encoder, boolean shouldSignalMemberProtocolEncoder) {
        this.supportedProtocol = supportedProtocol;
        this.inboundHandlers = next;
        this.encoder = encoder;
        this.shouldSignalMemberProtocolEncoder = shouldSignalMemberProtocolEncoder;
    }

    @Override
    public void handlerAdded() {
        this.initSrcBuffer(3);
    }

    @Override
    public HandlerStatus onRead() {
        ((ByteBuffer)this.src).flip();
        try {
            if (((ByteBuffer)this.src).remaining() < 3) {
                HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                return handlerStatus;
            }
            this.verifyProtocol(this.loadProtocol());
            this.encoder.signalProtocolVerified();
            this.initConnection();
            this.setupNextDecoder();
            if (!this.channel.isClientMode()) {
                this.encoder.setupNextEncoder();
            }
            if (this.shouldSignalMemberProtocolEncoder) {
                ((MemberProtocolEncoder)this.encoder.getFirstOutboundHandler()).signalEncoderCanReplace();
            }
            HandlerStatus handlerStatus = HandlerStatus.CLEAN;
            return handlerStatus;
        }
        finally {
            IOUtil.compactOrClear((ByteBuffer)this.src);
        }
    }

    protected void setupNextDecoder() {
        this.channel.inboundPipeline().replace(this, this.inboundHandlers);
    }

    protected void verifyProtocol(String incomingProtocol) {
        if (!incomingProtocol.equals(this.supportedProtocol.getDescriptor())) {
            this.encoder.signalWrongProtocol();
            String message = "Unsupported protocol exchange detected, expected protocol: " + this.supportedProtocol.name() + ", actual protocol or first three bytes are: " + incomingProtocol;
            if (incomingProtocol.equals("HZX")) {
                message = "Instance to be connected replied with HZX. This means a different protocol than expected sent to target instance";
            }
            throw new ProtocolException(message);
        }
    }

    private String loadProtocol() {
        byte[] protocolBytes = new byte[3];
        ((ByteBuffer)this.src).get(protocolBytes);
        return StringUtil.bytesToString(protocolBytes);
    }

    private void initConnection() {
        if (this.supportedProtocol == ProtocolType.MEMBER) {
            TcpServerConnection connection = (TcpServerConnection)this.channel.attributeMap().get(ServerConnection.class);
            connection.setConnectionType("MEMBER");
        }
    }
}

