/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.io.IOException;

public class LazyTarget
implements IdentifiedDataSerializable {
    private Data serialized;
    private Object deserialized;

    public LazyTarget() {
    }

    public LazyTarget(Data serialized, Object deserialized) {
        assert (serialized != null || deserialized != null);
        this.serialized = serialized;
        this.deserialized = deserialized;
    }

    public Object deserialize(InternalSerializationService serializationService) {
        try {
            if (this.deserialized == null) {
                this.deserialized = serializationService.toObject(this.serialized);
            }
            QueryDataType type = QueryDataTypeUtils.resolveTypeForClass(this.deserialized.getClass());
            return type.normalize(this.deserialized);
        }
        catch (Exception e) {
            throw QueryException.dataException("Failed to deserialize map entry key or value: " + e.getMessage(), e);
        }
    }

    public Data getSerialized() {
        return this.serialized;
    }

    public void setSerialized(Data serialized) {
        this.serialized = serialized;
    }

    public Object getDeserialized() {
        return this.deserialized;
    }

    public void setDeserialized(Object deserialized) {
        this.deserialized = deserialized;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        if (this.serialized != null) {
            out.writeBoolean(true);
            out.writeByteArray(this.serialized.toByteArray());
        } else {
            out.writeBoolean(false);
            out.writeObject(this.deserialized);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        if (in.readBoolean()) {
            this.serialized = new HeapData(in.readByteArray());
        } else {
            this.deserialized = in.readObject();
        }
    }
}

