/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.MoreObjects;
import com.yubico.u2f.data.messages.json.JsonSerializable;
import com.yubico.u2f.data.messages.key.util.CertificateParser;
import com.yubico.u2f.data.messages.key.util.U2fB64Encoding;
import com.yubico.u2f.exceptions.InvalidDeviceCounterException;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.io.Serializable;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import lombok.Generated;

public class DeviceRegistration
extends JsonSerializable
implements Serializable {
    private static final long serialVersionUID = -142942195464329902L;
    public static final long INITIAL_COUNTER_VALUE = -1L;
    @JsonProperty
    private final String keyHandle;
    @JsonProperty
    private final String publicKey;
    @JsonProperty
    private final String attestationCert;
    @JsonProperty
    private long counter;
    @JsonProperty
    private boolean compromised;

    @JsonCreator
    public DeviceRegistration(@JsonProperty(value="keyHandle") String keyHandle, @JsonProperty(value="publicKey") String publicKey, @JsonProperty(value="attestationCert") String attestationCert, @JsonProperty(value="counter") long counter, @JsonProperty(value="compromised") boolean compromised) {
        this.keyHandle = keyHandle;
        this.publicKey = publicKey;
        this.attestationCert = attestationCert;
        this.counter = counter;
        this.compromised = compromised;
    }

    public DeviceRegistration(String keyHandle, String publicKey, X509Certificate attestationCert, long counter) throws U2fBadInputException {
        this.keyHandle = keyHandle;
        this.publicKey = publicKey;
        try {
            this.attestationCert = U2fB64Encoding.encode(attestationCert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new U2fBadInputException("Malformed attestation certificate", e);
        }
        this.counter = counter;
    }

    public String getKeyHandle() {
        return this.keyHandle;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    @JsonIgnore
    public X509Certificate getAttestationCertificate() throws U2fBadInputException, CertificateException {
        if (this.attestationCert == null) {
            return null;
        }
        return CertificateParser.parseDer(U2fB64Encoding.decode(this.attestationCert));
    }

    public long getCounter() {
        return this.counter;
    }

    public boolean isCompromised() {
        return this.compromised;
    }

    public void markCompromised() {
        this.compromised = true;
    }

    @Override
    public String toString() {
        X509Certificate certificate = null;
        try {
            certificate = this.getAttestationCertificate();
        }
        catch (CertificateException certificateException) {
        }
        catch (U2fBadInputException u2fBadInputException) {
            // empty catch block
        }
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("Key handle", (Object)this.keyHandle).add("Public key", (Object)this.publicKey).add("Counter", this.counter).add("Attestation certificate", (Object)certificate).toString();
    }

    public static DeviceRegistration fromJson(String json) throws U2fBadInputException {
        return DeviceRegistration.fromJson(json, DeviceRegistration.class);
    }

    @Override
    public String toJson() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)new DeviceWithoutCertificate(this.keyHandle, this.publicKey, this.counter, this.compromised));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toJsonWithAttestationCert() {
        return super.toJson();
    }

    public void checkAndUpdateCounter(long clientCounter) throws InvalidDeviceCounterException {
        if (clientCounter <= this.getCounter()) {
            this.markCompromised();
            throw new InvalidDeviceCounterException(this);
        }
        this.counter = clientCounter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceRegistration)) {
            return false;
        }
        DeviceRegistration other = (DeviceRegistration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$keyHandle = this.getKeyHandle();
        String other$keyHandle = other.getKeyHandle();
        if (this$keyHandle == null ? other$keyHandle != null : !this$keyHandle.equals(other$keyHandle)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$attestationCert = this.attestationCert;
        String other$attestationCert = other.attestationCert;
        return !(this$attestationCert == null ? other$attestationCert != null : !this$attestationCert.equals(other$attestationCert));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeviceRegistration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyHandle = this.getKeyHandle();
        result = result * 59 + ($keyHandle == null ? 43 : $keyHandle.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $attestationCert = this.attestationCert;
        result = result * 59 + ($attestationCert == null ? 43 : $attestationCert.hashCode());
        return result;
    }

    private static class DeviceWithoutCertificate {
        @JsonProperty
        private final String keyHandle;
        @JsonProperty
        private final String publicKey;
        @JsonProperty
        private final long counter;
        @JsonProperty
        private final boolean compromised;

        private DeviceWithoutCertificate(String keyHandle, String publicKey, long counter, boolean compromised) {
            this.keyHandle = keyHandle;
            this.publicKey = publicKey;
            this.counter = counter;
            this.compromised = compromised;
        }
    }
}

