/**
 * Please modify this class to meet your needs
 * This class is not complete
 */

package com.openexchange.sessiond.soap.soap;

import java.rmi.RemoteException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import com.openexchange.java.Strings;
import com.openexchange.sessiond.rmi.SessiondRMIService;
import com.openexchange.sessiond.soap.dataobjects.Credentials;
import javax.jws.WebService;

/**
 * This class was generated by Apache CXF 2.6.0 2012-06-01T18:24:58.917+02:00 Generated source version: 2.6.0
 */

@WebService(serviceName = "OXSessionService", portName = "OXSessionServiceHttpsEndpoint", targetNamespace = "http://soap.sessiond.openexchange.com",
// wsdlLocation = "null",
endpointInterface = "com.openexchange.sessiond.soap.soap.OXSessionServicePortType")
@SuppressWarnings("deprecation")
public class OXSessionServicePortTypeImpl implements OXSessionServicePortType {

    public static final AtomicReference<SessiondRMIService> SESSIOND_REFERENCE = new AtomicReference<>();

    private static SessiondRMIService getSessiondRMIService() throws RemoteException_Exception {
        final SessiondRMIService sessiondRMIService = SESSIOND_REFERENCE.get();
        if (null == sessiondRMIService) {
            throw new RemoteException_Exception("Missing " + SessiondRMIService.class.getName() + " instance.");
        }
        return sessiondRMIService;
    }

    @Override
    public void clearUserSession(ClearUserSession parameters) throws InvalidCredentialsException_Exception, RemoteException_Exception, NoSuchUserException_Exception {
        SessiondRMIService sessiondRMIService = getSessiondRMIService();
        try {
            String sessionId = parameters.getSessionId();
            if (Strings.isEmpty(sessionId)) {
                throw new RemoteException("Missing or invalid session identifier");
            }
            if (!sessiondRMIService.clearUserSession(sessionId, true, soap2Credentials(parameters.getAuth()))) {
                throw new RemoteException("No such session: " + sessionId);
            }
        } catch (RemoteException e) {
            com.openexchange.sessiond.soap.soap.RemoteException faultDetail = new com.openexchange.sessiond.soap.soap.RemoteException();
            com.openexchange.sessiond.soap.rmi.RemoteException value = new com.openexchange.sessiond.soap.rmi.RemoteException();
            value.setMessage(e.getMessage());
            faultDetail.setRemoteException(value);
            throw new RemoteException_Exception(e.getMessage(), faultDetail, e);
        }
    }

    @Override
    public void clearUserSessions(ClearUserSessions parameters) throws InvalidCredentialsException_Exception, RemoteException_Exception, NoSuchUserException_Exception {
        SessiondRMIService sessiondRMIService = getSessiondRMIService();
        try {
            int userId = parameters.getUserId().intValue();
            int contextId = parameters.getContextId().intValue();
            sessiondRMIService.clearUserSessionsGlobally(userId, contextId, soap2Credentials(parameters.getAuth()));
        } catch (RemoteException e) {
            com.openexchange.sessiond.soap.soap.RemoteException faultDetail = new com.openexchange.sessiond.soap.soap.RemoteException();
            com.openexchange.sessiond.soap.rmi.RemoteException value = new com.openexchange.sessiond.soap.rmi.RemoteException();
            value.setMessage(e.getMessage());
            faultDetail.setRemoteException(value);
            throw new RemoteException_Exception(e.getMessage(), faultDetail, e);
        }
    }

    @Override
    public void clearContextSessions(ClearContextSessions parameters) throws InvalidCredentialsException_Exception, RemoteException_Exception, NoSuchContextException_Exception {
        SessiondRMIService sessiondRMIService = getSessiondRMIService();
        try {
            int contextId = parameters.getContextId().intValue();
            sessiondRMIService.clearContextSessionsGlobally(contextId, soap2Credentials(parameters.getAuth()));
        } catch (RemoteException e) {
            com.openexchange.sessiond.soap.soap.RemoteException faultDetail = new com.openexchange.sessiond.soap.soap.RemoteException();
            com.openexchange.sessiond.soap.rmi.RemoteException value = new com.openexchange.sessiond.soap.rmi.RemoteException();
            value.setMessage(e.getMessage());
            faultDetail.setRemoteException(value);
            throw new RemoteException_Exception(e.getMessage(), faultDetail, e);
        }
    }

    @Override
    public void clearContextsSessions(ClearContextsSessions parameters) throws InvalidCredentialsException_Exception, RemoteException_Exception, NoSuchContextException_Exception {
        SessiondRMIService sessiondRMIService = getSessiondRMIService();
        try {
            String sContextIds = parameters.getContextIds();
            if (Strings.isEmpty(sContextIds)) {
                return;
            }

            String[] tokens = Strings.splitByComma(sContextIds);
            Set<Integer> contextIds = new LinkedHashSet<Integer>(tokens.length);
            for (String token : tokens) {
                int i = Strings.getUnsignedInt(token);
                if (i <= 0) {
                    throw new RemoteException("Not a (positive) number: " + token);
                }
                contextIds.add(Integer.valueOf(i));
            }

            sessiondRMIService.clearContextSessionsGlobally(contextIds, soap2Credentials(parameters.getAuth()));
        } catch (RemoteException e) {
            com.openexchange.sessiond.soap.soap.RemoteException faultDetail = new com.openexchange.sessiond.soap.soap.RemoteException();
            com.openexchange.sessiond.soap.rmi.RemoteException value = new com.openexchange.sessiond.soap.rmi.RemoteException();
            value.setMessage(e.getMessage());
            faultDetail.setRemoteException(value);
            throw new RemoteException_Exception(e.getMessage(), faultDetail, e);
        }
    }

    // ------------------------------------------------------------------------------------------------------------------------------------

    private static com.openexchange.auth.Credentials soap2Credentials(Credentials credentials) {
        return credentials == null ? null : new com.openexchange.auth.Credentials(credentials.getLogin(), credentials.getPassword());
    }

}
