/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

public abstract class AbstractClientHttpResponse
implements ClientHttpResponse {
    private final int statusCode;
    private final HttpHeaders headers;
    private final MultiValueMap<String, ResponseCookie> cookies;
    private final Flux<DataBuffer> body;

    protected AbstractClientHttpResponse(int statusCode, HttpHeaders headers, MultiValueMap<String, ResponseCookie> cookies, Flux<DataBuffer> body) {
        Assert.notNull((Object)headers, "Headers must not be null");
        Assert.notNull(body, "Body must not be null");
        this.statusCode = statusCode;
        this.headers = headers;
        this.cookies = cookies;
        this.body = AbstractClientHttpResponse.singleSubscription(body);
    }

    private static Flux<DataBuffer> singleSubscription(Flux<DataBuffer> body) {
        AtomicBoolean subscribed = new AtomicBoolean();
        return body.doOnSubscribe(s -> {
            if (!subscribed.compareAndSet(false, true)) {
                throw new IllegalStateException("The client response body can only be consumed once");
            }
        });
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.valueOf(this.statusCode);
    }

    @Override
    public int getRawStatusCode() {
        return this.statusCode;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.cookies;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.body;
    }
}

